#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

use Text::CSV;

{
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};
}

sub main {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    my $mapping_file = $ARGV[0] // die 'Please supply a path to file with mapping as a first argument';
    open(my $fh, '<', $mapping_file) or die "open: $!";

    my $tsv = Text::CSV->new({binary => 1, sep_char => "\t", eol => "\n", escape_char => undef, quote_char => undef});
    my $header = $tsv->getline($fh);
    die "Wrong number of columns in mapping file" unless @$header == 3;

    my %blocks;

    while (my $row = $tsv->getline($fh)) {
        my ($page_id, $old_block_id, $new_block_id) = @$row;

        $app->partner_db->transaction(
            sub {
                $app->partner_db->context_on_site_adfox_dsps->delete(
                    $app->partner_db->filter({campaign_id => $page_id, block_id => $old_block_id}));
                $app->partner_db->context_on_site_adfox_dsp_blocks->delete(
                    $app->partner_db->filter({campaign_id => $page_id, block_id => $old_block_id}));
                $app->partner_db->context_on_site_adfox_action_log->edit(
                    $app->partner_db->filter({elem_campaign_id => $page_id, elem_id => $old_block_id}),
                    {elem_id => $new_block_id});
                $app->partner_db->statistics_context_on_site_adfox->edit(
                    $app->partner_db->filter({campaign_id => $page_id, block_id => $old_block_id}),
                    {block_id => $new_block_id});
                $app->partner_db->_do(
                    qq(
                    UPDATE stat_report_params_digest
                    SET params = REPLACE(params, "R-AF-$page_id-$old_block_id", "R-AF-$page_id-$new_block_id")
                )
                );
                $app->partner_db->_do(
                    qq(
                    UPDATE statistics_reports
                    SET query = REPLACE(query, "R-AF-$page_id-$old_block_id", "R-AF-$page_id-$new_block_id")
                )
                );
                $app->partner_db->adfox_old_new_block_ids->add(
                    {page_id => $page_id, old_block_id => $old_block_id, new_block_id => $new_block_id});
                $app->partner_db->context_on_site_adfox->delete({campaign_id => $page_id, id => $old_block_id});
                $blocks{$page_id} //= [];
                push @{$blocks{$page_id}}, $new_block_id;
            }
        );
    }

    close($fh) or die "close: $!";

    for my $page (
        @{$app->context_on_site_campaign->get_all(filter => {page_id => [keys(%blocks)]}, fields => [qw(id page_id)])})
    {
        try {
            for my $block_id (@{$blocks{$page->{page_id}}}) {
                $app->partner_db->context_on_site_adfox->edit({campaign_id => $page->{page_id}, id => $block_id},
                    {is_custom_bk_data => 0});
            }
            $app->context_on_site_campaign->do_action($page->{id}, 'set_need_update');
            $app->context_on_site_campaign->update_in_bk({id => $page->{id}});
        }
        catch {
            my ($e) = @_;
            say Dumper($page);
            say $e->message;
        };
    }
}

main();
