#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

use Text::CSV;
use File::Temp qw(tempfile);

{
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};
}

sub main {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    my $rtb_ids = $app->partner_db->query->select(
        table  => $app->partner_db->context_on_site_rtb,
        fields => [qw(campaign_id id)],
    );

    my $intersection = $app->partner_db->query->select(
        table  => $app->partner_db->context_on_site_adfox,
        fields => [qw(campaign_id id)],
      )->join(
        table   => $rtb_ids,
        fields  => [qw(campaign_id id)],
        join_on => [
            AND => [
                [id          => '=' => {id          => $app->partner_db->context_on_site_adfox}],
                [campaign_id => '=' => {campaign_id => $app->partner_db->context_on_site_adfox}],
            ]
        ],
      )->get_all();

    my ($fh, $filename) = tempfile('PI_10286_intersection_XXXXXX', DIR => lib::abs::path('../../'));
    my $tsv = Text::CSV->new({binary => 1, sep_char => "\t", eol => "\n", escape_char => undef, quote_char => undef});
    $tsv->print($fh, [qw(page_id block_id)]);

    for my $block_key (@$intersection) {
        $tsv->print($fh, [$block_key->{campaign_id}, $block_key->{id}]);
    }
    close($fh) or die "close: $!";
    say "Intersection file - $filename";
}

main();
