#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт добавляет Instream блоки с категорией 'VH: Я.Спорт' на пейджи с partner_type=yahosting

=head1 USAGE

  perl -Ilib bin/oneshots/add_blocks_by_sample.pl

=head1 OPTIONS

  page_ids          - Список ID площадок через запятую
  page_list         - Список ID площадок в файле (построчно)
  sample            - Список блоков-образцов для создания
  rollback          - лог для отката
  exclude_page_ids  - площадки-исключения, список
  exclude_page_list - площадки-исключения, файл
  skip_deleted      - пропускать удаленные площадки
  skip_empty        - пропускать площадки без блоков
  skip_without_stat - пропускать площадки, где нет блоков со статистикой
  make_readonly     - закрыть новые блоки от редактирования

=cut

use qbit;
use Utils::ScriptWrapper;
use Utils::Oneshots::AddBlockBySample;

run(\&Utils::Oneshots::AddBlockBySample::main);

sub args {
    my ($opts) = @_;

    return (
        'exclude_page_ids:s'  => \$opts->{exclude_page_ids},
        'exclude_page_list:s' => \$opts->{exclude_page_list},
        'page_ids:s'          => \$opts->{page_ids},
        'page_list:s'         => \$opts->{page_list},
        'sample:s'            => \$opts->{sample},
        'skip_deleted!'       => \$opts->{skip_deleted},
        'skip_empty!'         => \$opts->{skip_empty},
        'skip_without_stat!'  => \$opts->{skip_without_stat},
        'make_readonly!'      => \$opts->{make_readonly},
    );
}
