#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Модуль предоставляет возможность создавать пейджи по образцу вместе с блоками

=head1 USAGE

  perl -Ilib bin/oneshots/add_blocks_by_sample.pl

=head1 OPTIONS

  caption_file      - Список площадок в файле (построчно)
  caption_list      - Список площадок (через запятую)
  sample            - ID площади-образца для создания
  domain            - Domain для page
  sample_type_only  - Список типов блоков площадки образца для копирования
  caption_mask      - Маска создания caption
  set_dsp_for_overlay_blocks - ycтановить корректное значение dsps для overlay блоков
  target_tag        - тэги для площадки
  partner_type      - тип партнера
  is_internal       - moneymap флаг
  login             - логин

=cut

use Utils::ScriptWrapper;
use Utils::Oneshots::AddPageBySample;

run(\&Utils::Oneshots::AddPageBySample::main);

sub args {
    my ($opts) = @_;

    return (
        'caption_list:s'               => \$opts->{caption_list},
        'caption_file:s'               => \$opts->{caption_file},
        'sample:s'                     => \$opts->{sample},
        'domain:s'                     => \$opts->{domain},
        'sample_type_only:s'           => \$opts->{sample_type_only},
        'caption_mask:s'               => \$opts->{caption_mask},
        'set_dsp_for_overlay_blocks:s' => \$opts->{set_dsp_for_overlay_blocks},
        'target_tags:s'                => \$opts->{target_tags},
        'partner_type:s'               => \$opts->{partner_type},
        'login:s'                      => \$opts->{login},
        'is_internal:s'                => \$opts->{is_internal},
    );
}
