#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

Это скрипт, с помощью которого просто обновить файлы с sql запросами, которые хранятся в проекте.
Скрипт не получает никаких параметров, нужно править код скрипта (так сделана специально, так как
пока скрипт не устоялся проще поправить код скрипта, чем менять список параметров).

Скрипт действует так:

 * создает базу данных
 * создает таблицы (на основании данных из lib/Application/Model/PartnerDB/*)
 * наливает данные из mocked_databases
 * выполняет sql запросы, которые указаны в этом скрипте
 * делает mysqldump указанных в этом скрипте таблиц и сохраняет их в mocked_databases

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../lib
  );
use qbit;
use Application;

# global vars

# subs
sub do_the_change {
    my (%opts) = @_;

    my $database = 'change_mocked_databases_' . $$;

    my $mysql_cmd = 'mysql --default-character-set utf8 -u root';
    `$mysql_cmd -e 'create database $database'`;

    `make partner_db_create_sql_show > partner_db_$$.sql`;
    `cat partner_db_$$.sql | $mysql_cmd $database`;

    # Заливаем все данные в базу
    my @table_names = map {chomp; $_ =~ s/\.sql\z//; $_} `cd $opts{dir}/partner_db; ls -1 *`;
    my @sort_tables = $opts{app}->partner_db->_sorted_tables(@table_names);

    foreach my $table (@sort_tables) {
        my $file_name = $opts{dir} . '/partner_db/' . $table . '.sql';
        `cat $file_name | $mysql_cmd $database`
    }

    # Меняем данные
    writefile('tmp.sql', $opts{sql});
    warn `cat tmp.sql | $mysql_cmd $database`;

    # Выгруажем что получилось
    foreach my $table (@{$opts{tables_to_update}}) {
        warn "## $table\n";

        my $file_name = $opts{dir} . '/partner_db/' . $table . '.sql';

        my $cmd = "
            mysqldump \\
                --user=root \\
                --no-create-info \\
                --compact \\
                --complete-insert \\
                --extended-insert=FALSE \\
                $database \\
                --tables $table";

        `$cmd > $file_name`;
    }

    # Чистим
    `$mysql_cmd -e 'drop database $database'`;
    `rm partner_db_$$.sql`;
    `rm tmp.sql`;
}

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    do_the_change(

        app => $app,

        # Может быть либо 'mocked_databases', либо 'mocked_databases_restapi'
        dir => 'mocked_databases_restapi',

        # sql запросы, который нужно выполнить, после того как будет создана база и туда будут налиты данные
        sql => "
select campaign_id, id, direct_block, url_background_color from internal_context_on_site_rtb where direct_block in ('horizontal', 'vertical', 'modernAdaptive');
update internal_context_on_site_rtb set url_background_color = '0000cc' where direct_block in ('horizontal', 'vertical', 'modernAdaptive');

select campaign_id, id, direct_block, url_background_color from context_on_site_rtb where direct_block in ('horizontal', 'vertical', 'modernAdaptive');
update context_on_site_rtb set url_background_color = '0000cc' where direct_block in ('horizontal', 'vertical', 'modernAdaptive');
        ",

        # Список таблиц, которые будут выгружены из базы в 'mocked_databases' (или в 'mocked_databases_restapi',
        # в зависимости от того что указано в параметре dir)
        tables_to_update => [
            qw(
              context_on_site_adfox
              context_on_site_direct
              context_on_site_rtb
              internal_context_on_site_direct
              internal_context_on_site_rtb
              internal_mobile_app_rtb
              internal_search_on_site_direct
              mobile_app_rtb
              search_on_site_direct
              )
        ],

    );

    $app->post_run();
    say "#END";
}
main();
__END__
