#!/usr/bin/perl

=encoding utf8

=head1 DESCRIPTION

Cкрипт принимает логины Adfox и ПИ, находит блоки на этой связке, удаляет все adfox-кое и удаляет саму связь
(см #PI-14984)

=head1 PARAMS

 login       - логин ПИ
 login_adfox - логин Adfox
 db          - БД (по дефолту DEV)
 dry-run     - только чтение (по дефолту)

=head1 USAGE

 field=( 1tv.com  petrov-dm-pkvs );  ADFOX=${field[0]};  LOGIN=${field[1]};
 ./bin/oneshots/erase_adfox_origin_and_brake_login_links.pl --login_adfox=$ADFOX  --login=$LOGIN  --db=dev --dry-run

=cut

use strict;
use warnings FATAL => 'all';

use Data::Dumper;
use Pod::Usage;
use Getopt::Long qw();

####
_run();
#####

sub _run {

    my ($login, $login_adfox, $dbname, $dry_run) = _get_args();

    printf "DB - %s\n", uc($dbname);
    printf "Mode - %s\n\n", $dry_run ? 'dry-run' : 'for real';
    printf "=== %s - %s\n", $login_adfox, $login;

    #### 1. это связи
    {
        my $query = qq[
            select
               U.login,
               A.*
            from
               user_adfox A
               inner join users U on (A.user_id = U.id )
            where ( A.adfox_login, U.login  ) in (
               ( "$login_adfox", "$login" )
            );
        ];

        trim_query(\$query);

        my $cmd = sprintf qq[
cat <<EOF | mysql_partner2 --server=$dbname -- -t
%s
EOF
        ], $query;

        my $data = `$cmd`;
        trim_query(\$data);

        die sprintf(q[Can't find link for logins "%s" and "%s" ], $login_adfox, $login) unless $data;

        $data ||= '--NO-DATA--';

        printf qq[
1. Соответственно это связи --- <{Список
%%%%(sql)
PRODUCTION> %s

%s
%%%%
}>
        ], $query, $data
    }

    #### 2. Проверяем наличие блоков на этих связках
    my ($page_blocks_context_str, $page_blocks_mobile_str);
    {
        my $out_context = '';
        {
            my $query = qq[
                select
                   campaign_id,
                   R.id,
                   if ( R.multistate & 1, 'deleted', '') as is_deleted,
                   if ( R.multistate & 2, 'working', '') as is_working,
                   U.login,
                   A.adfox_login
                from
                   context_on_site_rtb R
                   inner join
                      context_on_site_campaign C
                      on ( R.campaign_id = C.page_id )
                   inner join
                      user_adfox A
                      ON ( C.owner_id = A.user_id and  R.adfox_user_id = A.adfox_id )
                   inner join
                      users U
                      ON ( C.owner_id = U.id )
                where
                     ( A.adfox_login, U.login  ) IN (
                        ( "$login_adfox", "$login" )
                     )
                order by
                    campaign_id,
                    id
            ];

            trim_query(\$query);

            my $cmd = sprintf qq[
cat <<EOF | mysql_partner2 --server=$dbname -- -t
%s
EOF
            ], $query;

            my $data = `$cmd`;
            trim_query(\$data);
            $data ||= '--NO-DATA--';

            $out_context = qq[
  <{context_on_site_rtb
%%(sql)
PRODUCTION> $query

$data
%%
}>
            ];

            $cmd = sprintf qq[
cat <<EOF | mysql_partner2 --server=$dbname -- --skip-column-names
%s
EOF
            ], $query;
            my $data_tsv = `$cmd`;
            trim_query(\$data_tsv);
            $page_blocks_context_str = join ',',
              map {sprintf '(%d, %d)', $_->[0], $_->[1]} map {[split /\t/, $_]} split /\n/, $data_tsv;
        }

        my $out_mobile = '';
        {
            my $query = qq[
                select
                    R.context_page_id,
                    R.id,
                    if ( R.multistate & 1, 'deleted', '') as is_deleted,
                    if ( R.multistate & 2, 'working', '') as is_working,
                    A.adfox_login
                    from
                        mobile_app_rtb R
                        inner join
                            mobile_app_settings C
                            using ( context_page_id )
                        inner join
                            user_adfox A
                                ON ( C.owner_id = A.user_id and  R.adfox_user_id = A.adfox_id )
                        inner join
                            users U
                                ON ( C.owner_id = U.id )
                where
                    ( A.adfox_login, U.login  ) IN (
                        ( "$login_adfox", "$login" )
                    )
                order by
                    context_page_id,
                    id
            ];

            trim_query(\$query);

            my $cmd = sprintf qq[
cat <<EOF | mysql_partner2 --server=$dbname -- -t
%s
EOF
            ], $query;

            my $data = `$cmd`;
            trim_query(\$data);
            $data ||= '--NO-DATA--';

            $out_mobile = qq[
  <{mobile_app_rtb
%%(sql)
PRODUCTION> $query

$data
%%
}>
            ];

            $cmd = sprintf qq[
cat <<EOF | mysql_partner2 --server=$dbname -- --skip-column-names
%s
EOF
            ], $query;
            my $data_tsv = `$cmd`;
            trim_query(\$data_tsv);
            $page_blocks_mobile_str = join ',',
              map {sprintf '(%d, %d)', $_->[0], $_->[1]} map {[split /\t/, $_]} split /\n/, $data_tsv;
        }

        printf qq[
2. Проверяем наличие блоков на этих связках
  %s
  %s
        ], $out_context, $out_mobile;
    }

    #### 3. Затираю на блоке все adfox-кое
    {
        my $out_context = 'context_on_site_rtb - NO DATA';
        {

            my $sql_data = $page_blocks_context_str || '--NO DATA--';
            my $query = qq[
                select
                   campaign_id,
                   id,
                   adfox_user_id,
                   has_adfox_deals,
                   adfox_site_name,
                   adfox_section_name,
                   adfox_banner_description,
                   adfox_block
                FROM  context_on_site_rtb
                WHERE ( campaign_id, id ) IN (
                   $sql_data
                )
            ];

            trim_query(\$query);

            my $data = '--NO DATA--';
            if ($page_blocks_context_str) {

                my $cmd = sprintf qq[
cat <<EOF | mysql_partner2 --server=$dbname -- -t
%s
EOF
                ], $query;

                $data = `$cmd`;
                trim_query(\$data);
                $data ||= '--NO-DATA--';
            }

            my $query_delete = qq[
                UPDATE context_on_site_rtb set
                       adfox_user_id = null,
                       has_adfox_deals = 0,
                       adfox_site_name = '',
                       adfox_section_name = '',
                       adfox_banner_description = '',
                       private_auction = 0,
                       adfox_block = 0
                WHERE  ( campaign_id, id ) IN (
                    $sql_data
                )
            ];

            trim_query(\$query_delete);

            my $rows = $dry_run ? '--DRY RUN--' : '--NO DATA--';
            if ($page_blocks_context_str && !$dry_run) {

                my $cmd = sprintf qq[
cat <<EOF | mysql_partner2 --server=$dbname -- --skip-column-names
%s;
SELECT ROW_COUNT();
EOF
                ], $query_delete;
                $rows = `$cmd`;
                trim_query(\$rows);
            }

            $out_context = qq[
  <{context_on_site_rtb
%%(sql)
PRODUCTION> $query

$data
%%
}> --- <{Удаляю
%%(sql)
PRODUCTION> $query_delete

Query OK, $rows row affected
%%
}>
            ]
        }

        my $out_mobile = 'mobile_app_rtb - NO DATA';
        {
            my $sql_data = $page_blocks_mobile_str || '--NO DATA--';
            my $query = qq[
                select
                   context_page_id,
                   id,
                   adfox_user_id,
                   adfox_block
                FROM  mobile_app_rtb
                WHERE ( context_page_id, id ) IN (
                  $sql_data
                )
            ];

            trim_query(\$query);

            my $data = '--NO DATA--';
            if ($page_blocks_mobile_str) {

                my $cmd = sprintf qq[
cat <<EOF | mysql_partner2 --server=$dbname -- -t
%s
EOF
                ], $query;

                $data = `$cmd`;
                trim_query(\$data);
                $data ||= '--NO-DATA--';
            }

            my $query_delete = qq[
                UPDATE mobile_app_rtb set
                       adfox_user_id = null,
                       adfox_block = 0
                WHERE  ( context_page_id, id ) IN (
                    $sql_data
                )
            ];

            trim_query(\$query_delete);

            my $rows = $dry_run ? '--DRY RUN--' : '--NO DATA--';
            if ($page_blocks_mobile_str && !$dry_run) {

                my $cmd = sprintf qq[
cat <<EOF | mysql_partner2 --server=$dbname -- --skip-column-names
%s;
SELECT ROW_COUNT();
EOF
                ], $query_delete;
                $rows = `$cmd`;
                trim_query(\$rows);
            }

            $out_mobile = qq[
  <{mobile_app_rtb
%%(sql)
PRODUCTION> $query

$data
%%
}>  --- <{Удаляю
%%(sql)
PRODUCTION> $query_delete

Query OK, $rows row affected
%%
}>
            ]
        }

        printf qq[
3. Затираю на блоке все adfox-кое
%s %s
        ], $out_context, $out_mobile

    }

    # 4. Удаляю связь
    {

        my $query = qq[
            SET FOREIGN_KEY_CHECKS=0;

            delete A
                from user_adfox A
                    inner join users U on (A.user_id = U.id )
            where
                (A.adfox_login, U.login ) IN
                (
                    ( "$login_adfox", "$login" )
                );
        ];
        trim_query(\$query);

        my $rows = '--DRY RUN--';
        unless ($dry_run) {

            my $cmd = sprintf qq[
cat <<EOF | mysql_partner2 --server=$dbname -- --skip-column-names
%s
SELECT ROW_COUNT();
EOF
            ], $query;
            $rows = `$cmd`;
            trim_query(\$rows);
        }

        printf qq[
4. Удаляю связь --- <{Запрос
%%%%(sql)

PRODUCTION> %s

Query OK, %s row affected
%%%%
}>
        ], $query, $rows;
    }

    # 5. Проверяем что в таблицах нет записей которые ни на что не ссылаются
    {
        my $out_context = '';
        {
            my $query = qq[
                select
                   campaign_id,
                   R.ID,
                   if ( R.multistate & 1, 'deleted', '') as is_deleted,
                   if ( R.multistate & 2, 'working', '') as is_working,
                   U.login,
                   R.adfox_user_id,
                   A.adfox_id,
                   A.adfox_login
                from
                   context_on_site_rtb R
                   inner join
                      context_on_site_campaign C
                      on ( R.campaign_id = C.page_id )
                   inner join
                      users U
                      ON ( C.owner_id = U.id )
                   left join
                      user_adfox A
                      on ( C.owner_id = A.user_id
                      and R.adfox_user_id = A.adfox_id )
                where
                   R.adfox_user_id IS NOT NULL
                   and A.adfox_id is null
                order by
                   campaign_id, is_working desc, is_deleted desc, R.ID
            ];

            trim_query(\$query);

            my $cmd = sprintf qq[
cat <<EOF | mysql_partner2 --server=$dbname -- -t
%s
EOF
            ], $query;

            my $data = `$cmd`;
            trim_query(\$data);
            $data ||= '--NO-DATA--';

            $out_context = qq[
  <{context_on_site_rtb
%%(sql)
PRODUCTION> $query

$data
%%
}>
            ];
        }

        my $out_mobile = '';
        {
            my $query = qq[
                select
                   context_page_id,
                   R.ID,
                   if ( R.multistate & 1, 'deleted', '') as is_deleted,
                   if ( R.multistate & 2, 'working', '') as is_working,
                   U.login,
                   R.adfox_user_id,
                   A.adfox_id,
                   A.adfox_login
                from
                   mobile_app_rtb R
                   inner join
                         mobile_app_settings C
                         USING (context_page_id)
                   inner join
                      users U
                      ON ( C.owner_id = U.id )
                   left join
                      user_adfox A
                      on ( C.owner_id = A.user_id
                      and R.adfox_user_id = A.adfox_id )
                where
                   R.adfox_user_id IS NOT NULL
                   and A.adfox_id is null
                order by
                   context_page_id, is_working desc, is_deleted desc, R.ID;
            ];

            trim_query(\$query);

            my $cmd = sprintf qq[
cat <<EOF | mysql_partner2 --server=$dbname -- -t
%s
EOF
            ], $query;

            my $data = `$cmd`;
            trim_query(\$data);
            $data ||= '--NO-DATA--';

            $out_mobile = qq[
  <{mobile_app_rtb
%%(sql)
PRODUCTION> $query

$data
%%
}>
            ];
        }

        printf qq[
5. Проверяем что в таблицах нет записей которые ни на что не ссылаются
  %s
  %s
        ], $out_context, $out_mobile
    }

    1;
}

sub trim_query {
    my $str_ref = shift;

    $$str_ref =~ s/^\n+//;

    my ($pre) = ($$str_ref =~ /^(\s+)/);
    $$str_ref =~ s/^$pre//mg if $pre;

    $$str_ref =~ s/\s+$//;
    1;
}

sub _get_args {

    my $login       = '';
    my $login_adfox = '';
    my $db          = 'dev';
    my $dry_run     = 1;

    my $help = 0;
    Getopt::Long::GetOptions(
        #--- Obligatory
        'login=s'       => \$login,
        'login_adfox=s' => \$login_adfox,
        'db:s'          => \$db,
        'dry-run!'      => \$dry_run,
        #---
        'help|?|h' => \$help,
    ) or pod2usage(1);

    pod2usage(-verbose => 2, -noperldoc => 1) if $help;

    #-- Проверяем зн-ия входных параметров
    my $errors = [];

    if (!$login || !$login_adfox) {
        push @$errors, "You must specify both logins";
    }

    unless (grep {$db eq $_} qw(prod dev ts)) {
        push @$errors, 'DB should be "dev" or "prod"';
    }

    if (@$errors) {
        print join("\n", @$errors), "\n";
        pod2usage(-verbose => 2, -noperldoc => 1);
        exit(0);
    }

    return ($login, $login_adfox, $db, $dry_run);
}
