#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# project modules
use lib::abs qw(
  ../lib
  );
use qbit;
use Application;

# common modules
use feature 'say';
use Carp;
use DDP;

# global vars
my $RIGHTS;

# subs
sub login_as_user {
    my (%opts) = @_;

    my $app   = delete $opts{app};
    my $login = delete $opts{login};

    my $user = $app->partner_db->_get_all('select id from users where login = ?', $login,);

    if (@$user == 1) {
        my $user_id = $user->[0]->{id};

        my @rights = map {$_->{right}} @{
            $app->partner_db->_get_all(
                'select `right` from role_rights where role_id in (select role_id from user_role where user_id = ?);',
                $user_id,)
          };

        $RIGHTS = $app->add_tmp_rights(@rights);

        my $user = $app->users->get(
            $user_id,
            fields => [
                qw(
                  client_id
                  id
                  multistate
                  name
                  roles
                  )
            ],
        );
        $app->set_cur_user($user);

    } else {
        throw sprintf('Can\'t find login %s in database', $login);
    }
}

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    login_as_user(
        app   => $app,
        login => 'yndx-bessarabov',
    );

    no strict 'refs';
    no warnings 'redefine';
    local *{'QBit::Application::check_rights'} = sub {TRUE};

    my @users = grep {$_->{login} ne 'system-cron'} @{
        $app->users->get_all(
            fields => [qw(id client_id login)],
            filter => {client_id => 0,},
        )
      };

    foreach my $u (@users) {
        my $user_id = $u->{id};

        my $client_id = $app->users->get_client_id($user_id);

        say "login: $u->{login} user_id: $user_id client_id: $client_id";
        $app->users->edit($user_id, client_id => $client_id,);
    }

    $app->post_run();
    say "#END";
}
main();
__END__
