SELECT u.login
FROM users u
JOIN campaigns c ON c.uid = u.uid
LEFT JOIN (
    SELECT page_id, count(*) AS cnt FROM bilstatistics
    WHERE dt > '2014-10-01'
    GROUP BY page_id
) s ON s.page_id = c.bs_page
WHERE
    u.login IS NOT NULL
AND
    u.login NOT IN ('m-ru-text')                    /* as of 2016-11-09 this mail.ru login should stay in PI1 */
AND
    COALESCE(u.go_away_now_type, '') = ''           /* user is active in PI1, not migrated */
AND
    u.multistate IN ('BEG_3','BEG_15','BEG_16')     /* normal users in working states */
AND
    u.uid NOT IN (SELECT id FROM _aggr_dict)        /* NOT in aggregator own logins */
AND
    u.uid NOT IN (SELECT fake_id FROM _aggr_dict
        WHERE fake_id IS NOT NULL)                  /* NOT in aggregator proxy logins */
AND
    NOT (                                           /* NOT companies from Belarus implicitly under tut.by TsOP (not under other TsOPs) */
        COALESCE(u.citizenship, '') = 4
            AND COALESCE(u.cooperationtype, 0) = 2
            AND COALESCE(u.type, '') = ''
            AND COALESCE(c.aggregator, 0) = 0
    )
AND
    COALESCE(c.aggregator, 0) NOT IN (              /* NOT campaigns explicitly under TsOPs (excluding 168493321 (Yandex Europe AG), 198952652 (Язнаю), 2728867 (Яндекс.Украина.)) */
        88415289,       /* tut.by */
        17115692,
        18485917,
        18943806,
        20410355,
        20547938,
        21183634,
        21318926,
        22642266,
        24096246,
        24206123,
        26194278,
        27740204,
        8233196
    )
AND
    c.bs_page IS NOT NULL                           /* only pages with assigned BS page id */
AND
    c.campaign_type IN (2,3)                        /* only search and context campaign types */
AND (
    COALESCE(c.multistate, '') LIKE 'BS_WORK_%'     /* page in one of working or testing states even without statistics */
    OR COALESCE(c.multistate, '') LIKE 'BS_%_WORK_%'
    OR COALESCE(c.multistate, '') LIKE 'BST_WORK_%'
    OR COALESCE(c.multistate, '') LIKE 'BSM_WORK_%'
    OR (
        COALESCE(c.multistate, '') NOT IN (         /* or NOT in some old or exotic states */
            '33',
            '35',
            '40',
            '41',
            'ACCAGGR_33',
            'AGBLOCK_STOP_111',
            'BSTCHAG_ARCH_14',
            'RESEL_33',
            'RESELT_33',
            'RESELT_35',
            'VSEMP_STOP_111'
        )
        AND s.page_id IS NOT NULL                    /* and statistics exists for at least 2 years */
       )
)
GROUP BY u.login;
