SELECT u.login
FROM users u
JOIN campaigns c ON c.uid = u.uid
WHERE
    u.login IS NOT NULL
AND
    u.login NOT IN ('m-ru-text')                    /* as of 2016-11-09 this mail.ru login should stay in PI1 */
AND
    COALESCE(u.go_away_now_type, '') = ''           /* user is active in PI1, not migrated */
AND
    u.multistate IN ('BEG_3','BEG_15','BEG_16')     /* normal users in working states */
AND
    u.uid NOT IN (SELECT id FROM _aggr_dict)        /* NOT in aggregator own logins */
AND
    u.uid NOT IN (SELECT fake_id FROM _aggr_dict
        WHERE fake_id IS NOT NULL)                  /* NOT in aggregator proxy logins */
AND
    (                                               /* Companies from Belarus are all under tut.by TsOP */
        COALESCE(u.citizenship, '') = 4
            AND COALESCE(u.cooperationtype, 0) = 2
            AND COALESCE(u.type, '') = ''
    )
AND
    c.bs_page IS NOT NULL                           /* only pages with assigned BS page id */
AND
    c.campaign_type IN (2,3)                        /* only search and context campaign types */
AND (
    COALESCE(c.multistate, '') LIKE 'BS_WORK_%'     /* page in one of working or testing states even without statistics */
    OR COALESCE(c.multistate, '') LIKE 'BS_%_WORK_%'
    OR COALESCE(c.multistate, '') LIKE 'BST_WORK_%'
    OR COALESCE(c.multistate, '') LIKE 'BSM_WORK_%'
    OR (
        COALESCE(c.multistate, '') NOT IN (         /* or NOT in some old or exotic states */
            '33',
            '35',
            '40',
            '41',
            'ACCAGGR_33',
            'AGBLOCK_STOP_111',
            'BSTCHAG_ARCH_14',
            'RESEL_33',
            'RESELT_33',
            'RESELT_35',
            'VSEMP_STOP_111'
        )
        /* do not check for statistics for tut.by partners */
       )
)
GROUP BY u.login;
