#!/usr/bin/perl

use lib::abs qw(../lib);

use qbit;

use File::Find;
use SQL::Parser;

my $parser = SQL::Parser->new();

#partner_db/context_on_site_campaign.sql
my %FILE_NAMES = map {$_ => TRUE} @ARGV;

find(
    {wanted => \&process, follow => 1},
    lib::abs::path('../mocked_databases/partner_db/'),
    lib::abs::path('../mocked_databases_restapi/partner_db/')
);

sub process {
    return if !defined($File::Find::fullname) || $File::Find::fullname !~ /\.sql$/;

    if (%FILE_NAMES) {
        my $file_name = clone($File::Find::fullname);
        $file_name =~ s/^.+\/mocked_databases(?:_restapi)?\///;

        return unless $FILE_NAMES{$file_name};
    }

    my $content = readfile $File::Find::fullname;

    my @result = ();

    my $is_multi_comment = FALSE;

    my $comment = '';
    my $sql     = '';
    foreach (split(/\n/, $content)) {
        my $row = "$_\n";

        if ($is_multi_comment || $row =~ /^\s*\/\*/) {
            $is_multi_comment = $row !~ /\*\//;

            $comment .= $row;

            next;
        } elsif ($row =~ /^\s*#/ || $row =~ /^\s*--/) {
            $comment .= $row;

            next;
        }

        $sql .= $row;

        if ($row =~ /;$/) {
            $parser->parse($sql);

            my $structure = $parser->structure;

            if (  !exists($structure->{'errstr'})
                && exists($structure->{'command'})
                && $structure->{'command'} eq 'INSERT')
            {
                my @new_inserts = ();
                foreach my $value (@{$structure->{'values'}}) {
                    my %data = ();
                    @data{@{$structure->{'org_col_names'}}} = map {correct_value($_)} @$value;

                    my $set = join(",\n", map {"    $_ = $data{$_}"} sort keys(%data));

                    my $new_sql = sprintf("INSERT INTO\n    %s\nSET\n%s;", $structure->{'org_table_names'}[0], $set);

                    push(@new_inserts, $new_sql);
                }

                push(@result, $comment . join("\n\n", @new_inserts) . "\n");
            } else {
                push(@result, $comment . $sql);
            }

            $comment = '';
            $sql     = '';
        }
    }

    if (@result || length($comment) || length($sql)) {
        writefile($File::Find::fullname, join('', @result) . $comment . $sql);
    }
}

sub correct_value {
    my ($val) = @_;

    if (ref($val->{'value'}) eq 'ARRAY') {
        $val->{'value'} = @{$val->{'value'}} =
          1 ? "-$val->{'value'}[0]{value}" : $val->{'value'}[0]{value} + $val->{'value'}[1]{value};
    }

    if (defined($val->{'value'})) {
        if ($val->{'type'} eq 'string') {
            return "'$val->{'value'}'";
        } else {
            return $val->{'value'};
        }
    } else {
        return 'NULL';
    }
}
