#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;

use Carp;
use Getopt::Long;
use Term::ANSIColor qw(colored);

use lib::abs qw(
  ../lib
  );
use Utils::DB;

my ($TABLE, $ALTER, $USEPTKILL);

GetOptions(
    "table=s"     => \$TABLE,
    "alter=s"     => \$ALTER,
    "use-pt-kill" => \$USEPTKILL,
) or croak("Error in command line arguments. Stopped");

croak("Use --table and --alter") unless defined($TABLE) && defined($ALTER);

my $db = get_db_settings();

$ALTER =~ s/`/\\`/g;

my $sentinel_file = '/tmp/pt-kill-sentinel';

my $cmd_kill = sprintf(
'pt-kill --kill --daemonize --sentinel %s --victims all --interval 2 --log /tmp/pt-kill.log -h %s -P %s -u %s -p %s --database %s --match-info "\`%s\`" --ignore-info "(?i-smx:^insert|^update|^delete|^replace|^alter)"',
    $sentinel_file, @{$db->{'partner_db'}}{qw(host port user password database)}, $TABLE);

my $cmd_osc = sprintf(
'PTDEBUG=0 pt-online-schema-change h=%s,P=%s,u=%s,p=%s,D=%s,t=%s --alter "%s" --alter-foreign-keys-method=auto --critical-load Threads_running=128 --recursion-method none --chunk-size=10000 --statistics --execute',
    @{$db->{'partner_db'}}{qw(host port user password database)},
    $TABLE, $ALTER
);

print colored($cmd_osc, 'yellow') . "\n";

unlink($sentinel_file) if -e $sentinel_file;
system($cmd_kill) if $USEPTKILL;
system($cmd_osc);
system("touch $sentinel_file") if -e $sentinel_file;
