#!/usr/bin/perl

use lib::abs '../lib';

use qbit;
use Utils::ScriptWrapper;

sub args {
    my ($opts) = @_;

    return (
        'dsp_ids=s@'  => \$opts->{dsp_ids},
        'page_ids=s@' => \$opts->{page_ids},
    );
}

run(
    sub {
        my ($app, $opts) = @_;

        unless ($opts->{dsp_ids} && $opts->{page_ids}) {
            print logstr 'ERROR: dsp_ids and page_ids should be defined';
            return;
        }

        my %dsps_to_remove = map {$_ => 1} split /\s*,\s*/, join ',', @{$opts->{dsp_ids}};
        my @page_id_list = split /\s*,\s*/, join ',', @{$opts->{page_ids}};

        my %pages_to_update;

        my @model_list = map {$_->{model}} @{
            $app->partner_db->_get_all(
                'SELECT DISTINCT model FROM all_blocks WHERE page_id IN (' . join(',', @page_id_list) . ')'
            )
          };

        for my $model (@model_list) {
            # Если у продукта нет настройки DSP, скипаем
            next unless $app->$model->DOES('Application::Model::Role::Has::DSPS');

            print logstr 'PROCESS MODEL', $model;

            my @regular_blocks;
            my @godmode_blocks;

            my $page_id_field_name = $app->$model->get_page_id_field_name();

            my $block_list = $app->$model->get_all(
                filter => [page_id => 'IN' => \@page_id_list],
                fields => [$page_id_field_name, qw(id bk_data is_custom_bk_data)],
            );

            for my $block (@$block_list) {
                # Если блок в годмоде - апдейтим bk_data
                if ($block->{is_custom_bk_data}) {
                    my $bk_data = from_json($block->{bk_data});
                    my @new_dsp_info;
                    for my $dsp (@{$bk_data->{DSPInfo}}) {
                        # Отфильтровываем внешние DSP
                        if (exists($dsps_to_remove{$dsp->{DSPID}})) {
                            print logstr(
                                'DELETE_GODMODE_DSP',
                                {
                                    model   => $model,
                                    page_id => $block->{$page_id_field_name},
                                    id      => $block->{id},
                                    dsp_id  => $dsp->{DSPID},
                                }
                            );
                        } else {
                            push @new_dsp_info, $dsp;
                        }
                    }
                    # Если дспшек стало меньше, добавляем блок в список к апдейту годмода
                    if (@{$bk_data->{DSPInfo}} > @new_dsp_info) {
                        $bk_data->{DSPInfo} = \@new_dsp_info;
                        $block->{bk_data} = to_json($bk_data, pretty => 1);
                        push @godmode_blocks, $block;
                    }
                }
                # В список к удалению из block_dsps добавляем в любом случае
                # Даже если блок в годмоде, когда его вернут, внешних дсп там тоже не должно быть
                push @regular_blocks, [$block->{$page_id_field_name}, $block->{id}];

                $pages_to_update{$block->{$page_id_field_name}} = 1;
            }

            # Апдейтим годмоды
            $app->partner_db->$model->add_multi(\@godmode_blocks, duplicate_update => TRUE)
              if @godmode_blocks && !$opts->{dry_run};

            # Чистим block_dsps
            if (@regular_blocks) {
                my $regular_blocks_list = join(', ', map {"($_->[0], $_->[1])"} @regular_blocks);
                my $dsp_list            = join(', ', sort keys(%dsps_to_remove));
                my $delete              = qq(
                    DELETE FROM block_dsps
                    WHERE (page_id, block_id) IN ($regular_blocks_list)
                    AND dsp_id IN ($dsp_list)
                );
                $delete =~ s/\n/ /g;
                $delete =~ s/\s+/ /g;
                print logstr $delete;
                $app->partner_db->_do($delete) if !$opts->{dry_run};
            }
        }

        print logstr "PAGES TO UPDATE", [map {$_ + 0} sort {$a <=> $b} keys %pages_to_update];
    }
   )
