#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

#Скрипт основан на решении

L<http://stackoverflow.com/questions/26501104/sorting-module-subroutines-alphabetically>

=cut

=head1 SYNOPSIS

./bin/resort_subs.pl --all

или

./bin/resort_subs.pl --file lib/Application/Model/DSP.pm

=cut

# common modules
use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use lib::abs qw(
  ../lib
  );
use PPI;
use Pod::Usage;
use File::Slurp;
use Getopt::Long;
use Partner2::Code;

our @EXPECTED_SUB_ORDER = get_expected_sub_order();
our %SUB2NUMBER;

sub the_sort {
    my $a = $a->{name};
    my $b = $b->{name};

    my $is_a_underscore = ($a =~ /^_/) ? 1 : 0;
    my $is_b_underscore = ($b =~ /^_/) ? 1 : 0;

    return
         $SUB2NUMBER{$a} <=> $SUB2NUMBER{$b}
      || $is_a_underscore <=> $is_b_underscore
      || $a cmp $b;

    return 1;
}

sub main {

    my %args;
    GetOptions(\%args, 'help|h|?', 'all', 'file=s', 'modified') or die "Error. $0 is run incorrectly.\n";

    if ($args{help} || !%args) {
        pod2usage(1);
        exit;
    }

    my @files;

    if ($args{file}) {
        push @files, $args{file};
    } elsif ($args{'modified'}) {
        @files = grep {s/^(?:(?:\s*M)|(?:\?\?))\s*//} split(/\n/, `git status -s -u | grep -e .*\.pm`);
    } elsif ($args{all}) {
        @files = get_pm_files();
    } elsif ($args{all} && $args{file}) {
        say "Can't use both --all and --file";
        exit 1;
    }

    foreach my $file_name (@files) {
        say $file_name;

        my $src = read_file($file_name, {binmode => ':utf8',},);

        my $doc = PPI::Document->new(\$src);

        # Save Sub locations for later sorting
        my @group = ();
        my @subs  = ();

        my %EXPECTED_SUB = map {$_ => 1} grep {!ref($_)} @EXPECTED_SUB_ORDER;

        for my $i (0 .. $#{$doc->{children}}) {
            my $child = $doc->{children}[$i];

            my ($subtype, $subname) =
              $child->isa('PPI::Statement::Sub')
              ? grep {$_->isa('PPI::Token::Word')} @{$child->{children}}
              : ('', '');

            # Look for grouped subs, whitespace and comments.  Sort each group separately.
            my $is_related = ($subtype eq 'sub') || grep {$child->isa("PPI::Token::$_")} qw(Whitespace Comment Pod);

            # State change or end of stream
            if (my $range = $is_related .. (!$is_related || ($i == $#{$doc->{children}}))) {
                if ($is_related) {
                    push @group, $child;

                    if ($subtype) {
                        push @subs, {name => "$subname", children => [@group]};
                        @group = ();
                    }
                }

                if ($range =~ /E/) {
                    @group = ();

                    if (@subs) {

                        map {$SUB2NUMBER{$_->{name}} = 100_000} @subs;

                        my $j                   = 1;
                        my $regex_subs_to_order = get_regex_subs_to_order();
                        foreach my $sub_name (@EXPECTED_SUB_ORDER) {
                            if (ref($sub_name) eq 'Regexp') {
                                my @regex_subs = grep {$_ =~ /$sub_name/} map {$_->{name}} @subs;
                                my @filtered_subs = grep {!$EXPECTED_SUB{$_}} @regex_subs;
                                my $ordered_subs = $regex_subs_to_order->{$sub_name}->(\@filtered_subs);

                                foreach my $sub_name2 (@$ordered_subs) {
                                    $SUB2NUMBER{$sub_name2}   = ++$j;
                                    $EXPECTED_SUB{$sub_name2} = 1;
                                }
                            } else {
                                $SUB2NUMBER{$sub_name} = ++$j;
                            }
                        }

                        # Sort and Flatten
                        my @ordered = sort the_sort @subs;
                        my @sorted = map {@{$_->{children}}} @ordered;

                        # Assign back to document, and then reset group
                        my $min_index = $i - $range + 1;
                        @{$doc->{children}}[$min_index .. $min_index + $#sorted] = @sorted;

                        @subs = ();
                    }
                }
            }
        }

        write_file($file_name, {binmode => ':utf8',}, $doc->serialize(),);

    }
}
main();
__END__
