#!/usr/bin/perl

=encoding utf8

=head1 USAGE

  Command::cgi

    > HTTP_X_REAL_IP='5.255.228.81' \
        HTTP_HOST='jsonapi.dev-partner2.yandex.com' \
        REQUEST_METHOD='GET' \
        PATH_INFO='/v1/bkdata/R-A-1037-13' \
        HTTP_AUTHORIZATION="token $TOKEN" \
        HTTP_ACCEPT='application/vnd.api+json' \
        HTTP_COOKIE='fakelogin=vsheff' \
            perl -I./lib -I./local/lib/perl5 \
                ./bin/rest_api.psgi cgi

  Command::get

    > HTTP_X_REAL_IP='5.255.228.81' \
      HTTP_HOST='jsonapi.dev-partner2.yandex.com' \
        perl -I./lib -I./local/lib/perl5  \
            ./bin/rest_api.psgi get \
                -M GET \
                '/v1/bkdata/R-A-1037-13' \
                -H "Authorization: token $TOKEN" \
                -H 'Accept: application/vnd.api+json' \
                -H 'Cookie: fakelogin=vsheff' \
                -v

=cut

use strict;
use warnings;
use utf8;

use RestApi;

RestApi->new()->start();
