#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт для вотрывания ролей у юзера с предварительной остановкой площадок.

=head1 USAGE

  perl bin/revoke_roles.pl --logins=avonav --roles=9

=head1 OPTIONS

  logins  - Список логинов через запятую
  roles   - Список ролей через запятую
  commit  - применять изменения

=cut

use lib::abs qw(../lib);

use Pod::Usage;

use qbit;
use Utils::ScriptWrapper;
use Utils::Oneshots::RevokeRoles;

run(\&Utils::Oneshots::RevokeRoles::revoke_roles);

sub args {
    my ($opts) = @_;
    return (
        'roles:s'  => \$opts->{roles},
        'logins:s' => \$opts->{logins},
        'result:s' => \$opts->{result},
    );
}

sub prepare_args {
    my ($opts) = @_;

    if ($opts->{logins}) {
        $opts->{logins_list} = [split /,/, $opts->{logins}];
    } else {
        die "You must specify 'logins'\n";
    }
    if ($opts->{roles}) {
        $opts->{roles_list} = [split /,/, $opts->{roles}];
    } else {
        die "You must specify 'roles'\n";
    }
}
