#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Carp;
use Capture::Tiny ':all';
use Time::HiRes qw(gettimeofday tv_interval);

use lib::abs qw(
  ../lib
  );
use qbit;
use Cron;

# global vars

# subs

# main
sub main {

    use DDP;

    my $cron_data = Cron->new()->get_cron_methods();

    my $format = '%-30s %-30s %-30s %-30s %-30s';

    say sprintf $format, 'group', 'method', 'run time (seconds)', 'output', 'exit status';

    say '-' x length(sprintf $format, 1, 1, 1, 1, 1);

    foreach my $group (sort(keys(%$cron_data))) {

        foreach my $method (sort(keys(%{$cron_data->{$group}}))) {

            next if $method eq 'regular_update_statistics';
            next if $method eq 'update_dont_show_stat';
            next if (($group eq 'get_partner_pages') && ($method eq 'import_partner_pages_from_bk'));
            next if (($group eq 'system')            && ($method eq 'run_qbit_validator_checks'));
            next if (($group eq 'tns_dict')          && ($method eq 'update_tns_dict'));
            next if (($group eq 'ya_categories')     && ($method eq 'ya_categories_update'));

            my $t0 = [gettimeofday()];
            my ($stdout, $stderr, $exit_status) = capture {
                system("perl -Ilib -MCron -e'Cron->new->do' $group $method");
            };
            my $run_time_seconds = int(tv_interval($t0));

            if ($stdout ne '') {
                writefile($group . '__' . $method . '.stdout', $stdout);
            }

            if ($stderr ne '') {
                writefile($group . '__' . $method . '.stderr', $stderr);
            }

            say sprintf $format,
              $group,
              $method,
              $run_time_seconds,
              ($stdout eq '' && $stderr eq '' ? 'ok' : 'fail'),
              ($exit_status == 0 ? 'ok' : 'fail'),
              ;

        }
    }

}
main();
__END__
