#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт выполняет миграции еще ненакаченные на БД в соответствии с заданными параметрами

=head1 USAGE

  perl -Ilib bin/run_migrations.pl --without_manual --without_prompt --type=mysql --order=before --dry_run

=head1 OPTIONS

 without_manual
 without_prompt
 type
 order
 dry_run

=cut

use lib::abs qw(
  ../lib
  ../local/lib/perl5
  );

use qbit;

use utf8;
use Utils::ScriptWrapper 'util';
use Utils::MigrationApplier;
use File::Copy qw(copy);
use PiConstants qw($CONFIG_FILE_PATH  $DB_CONFIG_FILE_PATH);

sub args {
    my ($opts) = @_;

    return (
        'type:s'          => \$opts->{type},
        'order:s'         => \$opts->{order},
        'without_manual!' => \$opts->{without_manual},
        'without_prompt!' => \$opts->{without_prompt},
        'production!'     => \$opts->{production},
        'dont_fail!'      => \$opts->{dont_fail},
        'dry_run!'        => \$opts->{dry_run},
    );
}

sub configure_app {
    my ($opts) = @_;
    Utils::MigrationApplier::init_config($opts);
}

run(
    sub {
        my ($app, $opts) = @_;
        my $result = Utils::MigrationApplier::run_migrations($app, $opts);
        exit($result);
    }
   );
