#!/usr/bin/perl

=head1 DESCRIPTION
Скрипт показывает с помощью ORM запроса всех пользователей, у которых есть хотя бы одна внутренняя роль
и при этом нет данных в поле domain_login.
=cut

# common modules
use feature 'say';

# project modulesi
use lib::abs qw(
  ../lib
  );
use qbit;
use Application;

# main
sub main {
    my $app = Application->new();

    $app->pre_run();

    my $tmp_rights = $app->add_all_tmp_rights();

    my @internal_ids = map {$_->{'is_internal'} ? $_->{'id'} : ()} @{$app->rbac->get_roles()};

    my $data = $app->users->get_all(
        fields => [qw(id login name lastname midname email)],
        filter => [AND => [[role_id => '=' => \@internal_ids], [domain_login => "IS" => undef]]],
    );

    foreach my $el (@{$data}) {
        say to_json($el);
    }

    $app->post_run();
}
main();
__END__
