#!/bin/bash

# Скрипт находит упавшие тесты в тимсити по айдишке билда
# Example:
# ./teamcity_failed.sh 52285123

# Обновить упавшие тесты:
# $ export SELF_UPDATE=1
# $ ./bin/teamcity_failed.sh 52285123 | xargs ./prove2

BUILD_ID=$1

if [ -z "$BUILD_ID" ]; then
  echo "buildId argument is required!"
  exit 1
elif [[ ! $BUILD_ID =~ ^[0-9]+$ ]]; then
  echo "buildId must be a number!"
  exit 1
fi

if [ ! -e ~/.teamcity.token ]; then
  echo "Script failed! no teamcity token"
  echo "Follow https://oauth.yandex-team.ru/authorize?response_type=token&client_id=7feab4f3dd964c95b57ba7b6fa085cc5"
  echo "then save token to ~/.teamcity.token"
  exit 1
fi

curl -s -H "Authorization: OAuth `cat ~/.teamcity.token`" \
  "https://teamcity.yandex-team.ru/downloadBuildLog.html?buildId=$BUILD_ID" |
  grep "t/" |
  grep "Failed:" |
  awk '{print $5;}'
