#!/usr/bin/perl

use lib::abs qw(../lib);

use qbit;
use Application;
use DDP;

sub main {
    my ($template, $email, $vars) = @_;

    my $app = Application->new();
    $app->pre_run();

    p $app->api_sender->send(
        template => $template,
        to_email => $email,
        args     => from_json $vars,
    );
}

sub usage {print "usage: $0 <template> <email>\n"}

(@ARGV == 2 || @ARGV == 3) ? main(@ARGV) : usage();
