#!/usr/bin/perl -w
use Test::Partner2::Simple;
use Test::Partner2::Mock qw(restore_subs);

use qbit;

local $$ = 100_500;

my $MOCKED_DATABASES_RESTAPI = 'mocked_databases_restapi';

my @filtered_args = grep {$_ eq "all_pages" || $_ eq "all_blocks"} @ARGV;
my @tables = scalar @filtered_args ? @filtered_args : qw(all_pages all_blocks);
run_tests(
    sub {
        my ($app) = @_;

        restore_subs(qw(Application::Model::PartnerDB::all_pages));

        foreach my $method (qw(update_all_sources update_all_pages update_all_blocks)) {
            $app->do('dictionaries', $method);
        }

        foreach my $table (@tables) {
            data_to_sql($app, $table);
        }
    },
    application_package => 'Cron',
    mocked_databases    => $MOCKED_DATABASES_RESTAPI
);

sub data_to_sql {
    return unless defined($_[0]) && defined($_[1]);
    my ($app, $table_name) = @_;
    print "Converting table: " . $table_name . "\n";

    my $data  = $app->partner_db->$table_name->get_all();
    my $f_row = $data->[0];

    my @fields = sort keys(%$f_row);

    my $formater = "(" . "%s, " x (@fields - 1) . "%s)";

    my @rows = qw();
    foreach my $row (@$data) {
        push(@rows, sprintf($formater, map {$app->partner_db->quote($_)} @$row{@fields}));
    }

    my $sql_data =
      "INSERT INTO `$table_name` (" . join(", ", map {"`$_`"} @fields) . ") VALUES\n" . join(",\n", @rows) . ";\n";

    writefile("./java-dbschema/$table_name.data.sql", $sql_data);
}
