#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт для обновления существующих описаний моделей в swagger.
Обновляется список доступных полей через RestApi у модели,
если список ранее уже был описан. Обновляются доступные фильтры.

=head1 USAGE

./bin/update_swagger.pl

=cut

use strict;
use warnings;

use lib::abs '../lib';

use Utils::Swagger;
use Application;
use qbit;

$ENV{'LAZY_LOAD'} = TRUE;

my $app = Application->new();
$app->pre_run();

{
    no warnings 'redefine';

    *QBit::Application::check_rights = sub {1};
}

$app->set_cur_user({id => 0});

Utils::Swagger::update_swagger_json($app);

$app->post_run();
