#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт для валидации площадок.

=head1 USAGE

  perl bin/validator.pl --page_ids=12345,54321
  perl bin/validator.pl --file_path=pageids.txt

=head1 OPTIONS

  page_ids        - Список ID площадок через запятую (необязательный)
  file_path       - Путь к файлу со списком площадок (разделитель перевод строки или запятая)
  split           - Разбить задание на указанное количество потоков
  part            - Размер пачки для проверки
  result          - Путь к файлу с итоговым результатом
  timeout         - Сколько ждать перед повторным запуском в случае ошибки
  tries           - Количество попыток в случае неудачи

=cut

use lib::abs qw(../lib ../local/lib/perl5);

use Pod::Usage;

use qbit;
use Utils::ScriptWrapper 'util';
use Utils::Oneshots::Validator;

run(\&Utils::Oneshots::Validator::main);

sub prepare_args {
    my ($opts) = @_;

    my @page_ids;
    unless ($opts->{page_id_str} || $opts->{file_path}) {
        die "You must specify 'page_ids' or 'file_path'\n";
    } elsif ($opts->{file_path}) {
        unless (-r $opts->{file_path}) {
            die "Wrong file path '$opts->{file_path}'\n";
        } else {
            open(my $FH, "<", $opts->{file_path});
            while (my $page_id = <$FH>) {
                push @page_ids, grep {$_} split /\s*,\s*/, $page_id;
            }
            close $FH;
        }
    } elsif ($opts->{page_id_str}) {
        @page_ids = split /,/, $opts->{page_id_str};
    }

    $opts->{page_ids} = \@page_ids;
    $opts->{part} ||= 100;
}

sub args {
    my ($opts) = @_;
    return (
        'page_ids:s'  => \$opts->{page_id_str},
        'file_path:s' => \$opts->{file_path},
        'result:s'    => \$opts->{file_result},
        'part:i'      => \$opts->{part},
        'timeout:i'   => \$opts->{timeout},
        'tries:i'     => \$opts->{tries}
    );
}

sub key_data_for_split {
    my ($opts) = @_;
    return 'page_ids';
}
