#!/bin/bash

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

YT_TABLE_PATH=$1
YT_TABLE_SCHEMA=$2
STAGE=$3

if ! [ "$YT_TABLE_PATH" ]
then
    echo "no YT_TABLE_PATH";
    exit;
fi

if ! [ "$YT_TABLE_SCHEMA" ]
then
    echo "no YT_TABLE_SCHEMA";
    exit;
fi

YT_META_CLUSTER='pythia'
YT_REPLICA_LIST=('freud' 'hume')

if [[ $STAGE && $STAGE == "prod" ]];
then
    echo "~using PRODUCTION config";
    YT_META_CLUSTER='markov'
    YT_REPLICA_LIST=('hahn' 'arnold')
else
    echo "~using TEST config";
    for replica in "${YT_REPLICA_LIST[@]}" $YT_META_CLUSTER
    do
        yt remove $YT_TABLE_PATH --proxy $replica 2>/dev/null || true
    done
fi


REPLICATED_TABLE_ID=$(\
    yt create replicated_table $YT_TABLE_PATH --attr "{
      dynamic=%true;
      schema=$YT_TABLE_SCHEMA
    }"  --proxy $YT_META_CLUSTER
); echo $REPLICATED_TABLE_ID

for CLUSTER_NAME in "${YT_REPLICA_LIST[@]}"
do
    REPLICA_ID=$( \
        yt create table_replica --attr "{
            table_path=\"$YT_TABLE_PATH\";
            cluster_name=$CLUSTER_NAME;
            replica_path=\"$YT_TABLE_PATH\"
        }" --proxy $YT_META_CLUSTER
    ); echo $REPLICA_ID
    TABLE_ID=$( \
        yt create table $YT_TABLE_PATH --attr "{
           dynamic=%true;
           upstream_replica_id=\"$REPLICA_ID\";
           schema=$YT_TABLE_SCHEMA
        }" --proxy $CLUSTER_NAME
    ); echo $TABLE_ID

    yt mount-table $YT_TABLE_PATH --proxy $CLUSTER_NAME
    yt alter-table-replica "$REPLICA_ID" --enable --mode sync --proxy $YT_META_CLUSTER
done

yt mount-table $YT_TABLE_PATH --proxy $YT_META_CLUSTER

exit
