#!/bin/bash

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

YT_TABLE_PATH=$1
YT_TABLE_DATA=$2
STAGE=$3

if ! [ "$YT_TABLE_PATH" ]
then
    echo "no YT_TABLE_PATH";
    exit;
fi

if ! [ "YT_TABLE_DATA" ]
then
    echo "no YT_TABLE_DATA";
    exit;
fi

YT_META_CLUSTER='pythia'
YT_REPLICA_LIST=('freud' 'hume')

if [[ $STAGE && $STAGE == "prod" ]];
then
    echo "~using PRODUCTION config";
    YT_META_CLUSTER='markov'
    YT_REPLICA_LIST=('hahn' 'arnold')
else
    echo "~using TEST config";
fi

cat $YT_TABLE_DATA | yt insert-rows $YT_TABLE_PATH --format '<encode_utf8=%false>json' --proxy $YT_META_CLUSTER

exit
