/*global confirm*/
(function () {
    'use strict';
    BEM.DOM.decl('b-actions', {
        onSetMod: {
            js: function () {
                var popup = this.findBlockInside('b-popupa');
                var links = this.findBlocksInside('b-link');

                if (links != null) {
                    links.forEach(function (block) {
                        if (block.params != null && block.params.confirm) {
                            block.domElem.on('click', function (e) {
                                if (!confirm(block.params.confirm)) {
                                    e.preventDefault();
                                    popup.hide();
                                }
                            });
                        }
                    });
                }

                var modalTriggers = this.findBlocksInside('b-modal-trigger');

                if (modalTriggers !== null) {
                    modalTriggers.forEach(function (block) {
                        block.on('form-show', function () {
                            popup.hide();
                        });
                    });
                }

                this.findBlockInside('b-form-button')
                    .on('click', function () {
                        popup.toggle(this.domElem);
                    });
            }
        }
    });
})();
