(function () {
    'use strict';

    BEM.DOM.decl('b-ad-appearance', {
        onSetMod: {
            js: function () {
                this.__base.apply(this, arguments);

                this._$sitelinks = this.elem('sitelinks');
                this._$noSitelinks = this.elem('no-sitelinks');

                if (!this._$sitelinks.length && !this._$noSitelinks.length) {
                    return;
                }

                if (this._$sitelinks.length) {
                    this._sitelinks = this._$sitelinks.bem('pi-form-checkbox');
                    this._refreshSiteLinks();
                    this._sitelinks.on('change', this._refreshNoSiteLinks, this);
                }

                this._checkbox = this.findBlockOn(this.elem('sitelinks'), 'b-form-checkbox');
                this._checkbox.on('change', this._changeColorpickerState, this);
                this._changeColorpickerState();
            }
        },

        /**
         * Отключает контрол для выбора цвета, если галочка снята.
         */
        _changeColorpickerState: function () {
            var checked = this._checkbox.hasMod('checked', 'yes');
            this._linkedColorpicker || (this._linkedColorpicker = this
                .findBlockInside(this.elem('sitelinks').closest('.b-fieldgroup'), 'b-form-colorpicker'));

            this._linkedColorpicker.setMod('disabled', checked ? '' : 'yes');
        },

        _refreshSiteLinks: function () {
            this._sitelinks.val(this._$noSitelinks.val() !== 'true');
            this._$noSitelinks.val('on');
        },

        _refreshNoSiteLinks: function () {
            if (this._sitelinks.val()) {
                this._$noSitelinks.attr('disabled', 'disabled');
            } else {
                this._$noSitelinks.removeAttr('disabled');
            }
        },

        /**
         * param {object} settings
         * @return {object}
         */
        _formatSettings: function (/*settings*/) {
            var settings = this.__base.apply(this, arguments);

            if (typeof settings.no_sitelinks !== 'undefined') {
                settings.no_sitelinks = Boolean(settings.no_sitelinks);
            }
            delete settings.sitelinks;

            return settings;
        }
    });
})();
