(function ($, BEM, undefined) {
    'use strict';

    // Дефолтные значения полей
    // Дополнят параметры из основного файла
    var defaultValues = {
        defaults: {
            type: 'vertical',
            border_type: 'block'
        },
        posterVertical: {
            border_type: 'ad',
            border_color: 'DDDCDA',
            header_bg_color: 'FFFFFF',
            hover_color: 'DD0000'
        },
        posterHorizontal: {
            border_type: 'ad',
            border_color: 'DDDCDA',
            header_bg_color: 'FFFFFF',
            hover_color: 'DD0000'
        }
    };

    // Будет подмешено для передачи в блок PCode
    // Заменят параметры из основного файла
    var defaultSettings = {
        // нужно для работы настройки images_first,
        // которая работает только для внутренних площадок
        isYandexPage: '1',
        onRtb: false,
        partnerId: '777',
        ad_format: 'direct',
        direct_header_position: 'bottom'
    };

    // Дефолтные параметры блока pcode для разных типов блоков
    // Заменят параметры из основного файла
    var typeSettings = {
        defaults: {ads: 2},
        '1000x120': {ads: 3}
    };

    // Block

    BEM.DOM.decl({block: 'b-ad-appearance', modName: 'type', modVal: 'internal-context-direct'}, {
        onSetMod: {
            js: function () {
                this.__base.apply(this, arguments);
            }
        },

        /**
         * @return {object}
         **/
        _getDefaultSettings: function () {
            return defaultSettings;
        },

        /**
         * @param {string} type Тип блока
         * param {number} limit Количество объявлений
         * @return {object}
         **/
        _getTypeSettings: function (type/*, limit*/) {
            var settings = typeSettings.defaults;

            if (typeSettings[type]) {
                settings = typeSettings[type];
            }

            settings.orientation = this._getOrientation(type);

            return settings;
        },

        /**
         * @protected
         * @param {string} type
         * @return {object}
         */
        _getDefaultValues: function (type) {
            var values = this.__base.apply(this, arguments);
            return $.extend({}, values, defaultValues[type] || defaultValues.defaults);
        }
    });

})(jQuery, BEM);
