(function ($, BEM, undefined) {
    'use strict';

    // Дефолтные значения полей
    // Дополнят параметры из основного файла
    var defaultValues = {
        'default': {
            type: '240x400'
        },
        posterVertical: {
            border_type: 'ad',
            border_color: 'DDDCDA',
            header_bg_color: 'FFFFFF',
            hover_color: 'DD0000'
        },
        posterHorizontal: {
            border_type: 'ad',
            border_color: 'DDDCDA',
            header_bg_color: 'FFFFFF',
            hover_color: 'DD0000'
        }
    };

    // Будет подмешено для передачи в блок PCode
    // Заменят параметры из основного файла
    var defaultSettings = {
        // нужно для работы настройки images_first,
        // которая работает только для внутренних площадок
        isYandexPage: '1',
        onRtb: false,
        partnerId: '777',
        ad_format: 'direct',
        direct_header_position: 'bottom'
    };

    // Дефолтные параметры блока pcode для разных типов блоков
    // Заменят параметры из основного файла
    var typeSettings = {
        'default': {ads: 4},
        '160x600': {ads: 4},
        '240x400': {ads: 4},
        '300x250': {ads: 3},
        '300x300': {ads: 3},
        '728x90':  {ads: 3},
        '1000x120': {ads: 4},
        grid: {ads: 4}
    };

    // Helpers

    BEM.DOM.decl({block: 'b-ad-appearance', modName: 'type', modVal: 'internal-context-rtb'}, {
        _getDefaultSettings: function () {
            return defaultSettings;
        },

        /**
         * @param {string} type Тип блока
         * param {number} limit Количество объявлений
         * @return {object}
         **/
        _getTypeSettings: function (type, limit) {
            var settings = typeSettings['default'];

            // Для типов vertical и horizontal приходит limit, который
            // и нужно использовать для отображения примера
            if (type === 'vertical' || type === 'horizontal') {
                settings = {
                    ads: limit || typeSettings['default'].ads
                };
            } else if (typeof typeSettings[type] !== 'undefined') {
                settings = typeSettings[type];
            } else {
                settings = typeSettings['default'];
            }

            settings.orientation = this._getOrientation(type);

            return settings;
        },

        /**
         * @protected
         * @param {string} type
         * @return {object}
         */
        _getDefaultValues: function (type) {
            var values = this.__base.apply(this, arguments);
            return $.extend({}, values, defaultValues[type] || defaultValues['default']);
        }
    });

})(jQuery, BEM);
