(function ($, BEM, undefined) {
    'use strict';

    // Дефолтные значения полей
    // Дополнят параметры из основного файла
    var defaultValues = {
        type: 'vertical',
        limit: 1
    };

    // Будет подмешено для передачи в блок PCode
    // Заменят параметры из основного файла
    var defaultSettings = {
        onRtb: false,
        partnerId: '777',
        ad_format: 'premium',
        border_type: 'block',
        direct_header_position: 'bottom'
    };

    // Дефолтные параметры блока pcode для разных типов блоков
    // Заменят параметры из основного файла
    var typeSettings = {
        'default': {orientation: 'vertical'}
    };

    BEM.DOM.decl({block: 'b-ad-appearance', modName: 'type', modVal: 'internal-search-premium'}, {
        /**
         * @return {object}
         **/
        _getDefaultSettings: function () {
            return defaultSettings;
        },

        /**
         * param {string} type Тип блока
         * param {number} limit Количество объявлений
         * @return {object}
         **/
        _getTypeSettings: function (/*type, limit*/) {
            return typeSettings['default'];
        },

        _getDefaultValues: function () {
            var values = this.__base.apply(this, arguments);
            return $.extend({}, values, defaultValues);
        }
    });

})(jQuery, BEM);
