/*jslint bitwise: true, plusplus: true, nomen:true*/
/*globals jQuery, BEM*/
(function ($, BEM, undefined) {

    'use strict';

    var extend = $.extend;

    // Дефолтные значения полей
    // при преобразовании значений к единому виду опираюсь
    // на тип дефолтного значения
    var defaultValues = {
        all_color:       '000000',
        bg_color:        'FFF9F0',
        border_type:     'none',
        border_color:    'FBE5C0',
        border_radius:   false,
        favicon:         true,
        no_sitelinks:    false,
        images_first:    false,
        links_underline: true,
        hover_color:     '0066FF',
        header_bg_color: 'FEEAC7',
        site_bg_color:   'FFFFFF',
        text_color:      '000000',
        title_color:     '0000CC',
        url_color:       '006600',
        url_background_color: '0000CC',
        sitelinks_color: '0000CC'
    };

    // поля, checked по дефолту
    var defaultCheckedColors = [
        'header_bg_color'
    ];

    /**
     * Преобразует нужные поля к объекту
     *
     * @param {string} name
     * @param {string|boolean} value
     * @return {object} {value:string|boolean, checked:boolean}
     **/
    function parseValue(name, value, defValue) {
        var result = {value: value, checked: false};

        if (typeof defValue === 'boolean' && typeof value !== 'boolean') {
            // предполагаю, что в этом случае value или пустая строка или 0 строкой или 1 строкой
            result.value = Boolean(parseInt(value, 10));
            result.checked = undefined;
        } else {
            if (Boolean(value)) {
                // если не пустая строка, то checked
                result.checked = true;
            } else {
                // а если пустая, то используем дефолтное значение
                result.value = defValue;
            }
        }

        return result;
    }

    /**
     * Для того, чтобы понять, что блок новый и нужно
     * использовать дефолтный значения
     *
     * @param {object} obj
     **/
    function hasValues(obj) {
        var copy = $.extend(true, {}, obj);
        delete copy.type;
        delete copy.limit;
        return !$.isEmptyObject(copy);
    }

    /**
     * @param {number} prefixLength,
     * @param {object} settings
     * @param {string|number|boolean} value
     **/
    function setParam(prefixLength, settings, value) {
        var paramName = value.name;
        if (paramName && paramName.length > prefixLength) {
            paramName = value.name.substr(prefixLength);
            settings[paramName] = value.value;
        }
        return settings;
    }

    /**
     * Разбирает фиксированные типы на ширину и высоту
     *
     * @param {string} type Напимер, '240x0'
     * @return {object} {width: {string}, height: {string}}
     **/
    function getFixedSizes(type) {
        var sizes = /([0-9]+)x([0-9]+)/.exec(type);

        if (sizes === null) {
            return null;
        }

        return {
            width: sizes[1],
            height: sizes[2]
        };
    }

    /**
     * Возвращает ориентацию блока
     * Если ширина фиксированного блока больше максимальной - вернется горизронтальный тип
     *
     * @param {string} type
     * @param {number} maxVerticalWidth
     **/
    function getOrientation(type, maxVerticalWidth) {
        var size = getFixedSizes(type);
        var verticalTypes = ['vertical', 'posterVertical'];

        if (verticalTypes.indexOf(type) !== -1 || size !== null && size.width <= maxVerticalWidth) {
            return 'vertical';
        } else {
            return 'horizontal';
        }
    }

    // Block

    BEM.DOM.decl('b-ad-appearance', {
        onSetMod: {
            js: function () {
                this._bFieldSet = this.findBlockInside('b-fieldset');
                if (this._bFieldSet === null) {
                    return;
                }

                this._twoColumnFieldsets = this.findBlocksInside({
                    block: 'b-fieldset',
                    modName: 'two-columns',
                    modVal: 'yes'
                });

                // Максимальная ширина фиксированного блока, при котором отображение полей формы и превью
                // будет вертикального типа (поля в одну колонку, превью справа).
                // Предположила, что пока подойдет половина ширины блока, если форма станет сложнее для ветикального
                // варианта или ширина блока меньше - нужно будет придумать другой
                // вариант расчета.
                this._maxVerticalWidth = this.domElem.width() / 2;

                this._setValues();

                this.afterCurrentEvent(function () {
                    this._bFieldSet.on('change', this._onChange, this);
                }, this);
            },

            orientation: {
                vertical: function () {
                    this._twoColumnFieldsets.forEach(function (block) {
                        block.setMod('two-columns', 'no');
                    });
                },

                horizontal: function () {
                    this._twoColumnFieldsets.forEach(function (block) {
                        block.setMod('two-columns', 'yes');
                    });
                }
            }
        },

        /**
         * Заглушка, реальные данные зависят от типа
         *
         * @return {object}
         **/
        _getDefaultSettings: function () {
            return {};
        },

        /**
         * Заглушка, реальные данные зависят от типа
         *
         * param {string} type Тип блока
         * @return {object}
         **/
        _getTypeSettings: function (/*type, limit*/) {
            return {};
        },

        /**
         * Ищеи элемент соответствующий ключу, при этом
         * нижнее подчеркивание заменяя на минус
         * Если блок на элементе не найден, то возвращает сам элемент
         *
         * @param {string} fieldId Название поля
         */
        _getBlockByKey: function (fieldId) {
            var elemName = fieldId.replace(/_/g, '-');
            var elem = this.elem(elemName);
            return this.findBlockOn(elem, 'pi-form-colorpicker') ||
                this.findBlockOn(elem, 'pi-form-select') ||
                this.findBlockOn(elem, 'pi-form-checkbox') ||
                this.findBlockOn(elem, 'pi-form-input') || elem;
        },

        /**
         * Возвращает дефолтные значения
         * Метод нужен, чтобы в модах можно было переопределить его
         *
         * @return {object}
         **/
        _getDefaultValues: function () {
            return defaultValues;
        },

        /**
         * Возвращает поля, которые должны быть отмечены (checked) по дефолту
         * Метод нужен, чтобы в модах можно было переопределить его
         *
         * @return {array}
         **/
        _getDefaultChecked: function () {
            return defaultCheckedColors;
        },

        /**
         * Если есть значения в this.params.values - проставляет дефолтные значения в поля
         * Если нет - дополняет this.params.values дефолтными значениями и проставляет в поля
         **/
        _setValues: function () {
            // значения полей
            var values = this.params.values;
            // дефолтные значения полей
            var defValues = this._getDefaultValues(this.params.values.type);
            // есть ли в значениях что-нибудь кроме type и limit
            var isEmpty = !hasValues(values);
            // если значений совсем не пришло, то берем дефолтные
            if (isEmpty) {
                values = defValues;
            }

            // Поля, которые должны быть отмечены (checked) по дефолту
            var defCheckedColors = this._getDefaultChecked();
            // Значение одного из полей
            var value;
            // Блок соответствующий полю
            var block;
            for (var name in values) {
                if (values.hasOwnProperty(name)) {
                    // приводим значения к общему виду {value:string|boolean, checked:boolean}
                    value = parseValue(name, values[name], defValues[name]);
                    // если блок свежесозданный
                    if (isEmpty) {
                        // проверяем отмечено ли поле по умолчанию
                        value.checked = defCheckedColors.indexOf(name) !== -1;
                    }
                    block = this._getBlockByKey(name);
                    // если блок, соответствующий полю существует в dom
                    if (block !== null && typeof block.val === 'function') {
                        block.val(value.value, value.checked);
                    }
                }
            }
        },

        /**
         * Собирает данные с формы, параметры для текущего типа блока и тригерит событие change
         **/
        _onChange: function () {
            // значения формы
            var settings = this._getSettings();
            // параметры типа блока
            var typeSettings = this._getTypeSettings(settings.type, settings.limit);

            // отображение полей vertical или horizontal
            this.setMod('orientation', typeSettings.orientation);
            // это событие ловит элемент demo-container и обновляет превью блока
            this.trigger('change', settings);
        },

        /**
         * Возвращает значения формы дополненные дефолтными значениями
         *
         * @return {object}
         **/
        _getSettings: function () {
            // дефолтные настройки блоков (_не_ значения полей)
            var settings = extend({}, this._getDefaultSettings());
            // значения полей формы
            var values = this.findBlockInside('b-fieldset').val();

            // преобразование к плоскому объекту и добывание названия поля (без префикса)
            settings = values.reduce(setParam.bind(this, this.params.fieldNamePrefix.length), settings);

            // некоторые поля нуждаются в преобразовании перед отправкой
            settings = this._formatSettings(settings);
            return settings;
        },

        /**
         * Преобразует некоторые поля настроек к нужному виду
         *
         * @param {object} settings
         * @return {object}
         */
        _formatSettings: function (settings) {
            var typeSettings;

            settings.height = settings.adaptive_height;
            settings.type = this.params.values.type;
            settings.limit = this.params.values.limit;
            if (!settings.limit) {
                typeSettings = this._getTypeSettings(settings.type, settings.limit);
                settings.limit = typeSettings.ads;
            }

            if (this.params.viewImages === 'yes') {
                settings.viewImages = true;
            }

            ['favicon', 'border_radius', 'links_underline', 'images_first']
                .reduce(function (s, name) {
                    s[name] = s[name] === 'on';
                    return s;
                }, settings);

            return settings;
        },

        /**
         * @param {string} type
         **/
        _getOrientation: function (type) {
            return getOrientation(type, this._maxVerticalWidth);
        }
    });

})(jQuery, BEM);
