(function () {
    'use strict';

    BEM.DOM.decl('b-ad-code', {
        onSetMod: {
            js: function () {
                this._bPopupa = this.findBlockOutside('b-popupa');
                if (this._bPopupa) {
                    this._bPopupa.on('show', this._onShow, this);
                }
            }
        },

        _initBlock: function () {
            BEM.DOM.after(this.elem('label'), BEMHTML.apply({
                block: 'b-ad-code',
                elem: 'clipboard'
            }));
            this._bClipboard = this.findBlockOn('clipboard', 'b-clipboard');
            this._bFormInput = this.findBlockOn(this._bClipboard.elem('input'), 'b-form-input');
            this.elem('async').on('change', this._drawCode.bind(this));
        },

        _onShow: function () {
            this.afterCurrentEvent(function () {
                if (typeof this._bClipboard === 'undefined') {
                    this._initBlock();
                }
                this._drawCode();
            }, this);
        },

        _drawCode: function () {
            var isAsync = this.elem('async')[0].checked;
            var id = this.params.id;

            this._bFormInput.val(isAsync ? this._getAsyncCode(id) : this._getCode(id));
        },

        /**
         * param {string} id
         * return {string}
         **/
        _getCode: function (/*id*/) {
            throw new Error('Method _getCode should be overriden in mod');
        },

        /**
         * param {string} id
         * return {string}
         **/
        _getAsyncCode: function (/*id*/) {
            throw new Error('Method _getAsuncCode should be overriden in mod');
        }
    });
})();
