(function () {
    'use strict';
    BEM.DOM.decl('b-ad-type', {
        onSetMod: {
            'lvl1-name': function (modName, modVal) {
                this.__base.apply(this, arguments);

                if (modVal === 'fixed') {
                    this._refreshFixed();
                } else {
                    this.delMod('lvl2-name');
                    this._lvl3Name = null;
                }
            }
        },

        _initBlock: function () {
            this.__base.apply(this, arguments);
            // {b-form-select}
            this._bFormSelect = null;
            // {string}
            this._lvl3Name = null;
        },

        _refreshFixed: function () {
            var $fixedSelect = this.elem('form-fixed-select');
            if (!$fixedSelect || $fixedSelect.length === 0) {
                return;
            }
            if (this._bFormSelect !== null) {
                this._bFormSelect.un('change');
            }
            BEM.DOM.update($fixedSelect, BEMHTML.apply(this._getElem()));
            this.dropElemCache('form-fixed-select-content', 'limit-input');

            this._bFormSelect = this.findBlockOn('form-fixed-select-content', 'b-form-select');
            this._bFormSelect.on('change', this._onSelectChange.bind(this));
        },

        _getElem: function () {
            var type = this._getFixedType(),
                types = this._nameToType.fixed.types,
                elem = {
                    block: 'b-ad-type',
                    elem: 'form-fixed-select-content',
                    types: types
                };

            if (type !== null) {
                elem.selectedId = type.id;
            }

            return elem;
        },

        _getFixedType: function () {
            var type = null,
                id = this.params.type;

            if (this._lvl3Name) {
                type = this._nameToType[this._lvl3Name];
            } else if (id) {
                type = this._idToType[id];
            }

            return type;
        },

        _onSelectChange: function (e) {
            var id = e.block.val(),
                type = this._idToType[id],
                name = type.parentName;

            this._lvl3Name = type.name;

            if (type !== undefined && name !== undefined) {
                this.setMod('lvl2-name', name);
            }

            this.elem('limit-input').val(type.banners);
        }

    });
})();
