(function () {
    'use strict';

    BEM.DOM.decl('b-ad-type', {
        onSetMod: {
            'lvl1-name': function (modName, modVal) {
                this.__base.apply(this, arguments);
                this._refreshRange(modVal);
            }
        },

        /**
         * Обновляет элемент выбора количества блоков
         **/
        _refreshRange: function (name) {
            var $limit = this.elem('form-limit'),
                type = null;

            if (!$limit || $limit.length === 0) {
                return;
            }

            if (name === undefined) {
                name = this.getMod('lvl1-name');
            }

            type = this._nameToType[name];
            this._refreshCountType(type);

            BEM.DOM.update(this.elem('form-limit-select'), BEMHTML.apply({
                block: 'b-ad-type',
                elem: 'form-limit-select-content',
                bannersMin: type.min_banners,
                bannersMax: type.max_banners,
                limit: this._limit
            }));
            this.dropElemCache('limit-input');
        },

        _refreshCountType: function (type) {
            var id = type.id;
            if (id !== undefined) {
                this.elem('type-input').val(id);
            }
        }
    });
})();
