(function () {
    'use strict';
    BEM.DOM.decl('b-ad-type', {
        onSetMod: {
            'lvl1-name': function (modName, modValue) {
                this.__base.apply(this, arguments);
                this._refreshOpts(modValue);
            }
        },

        _refreshOpts: function (name) {
            if (name === undefined) {
                name = this.getMod('lvl1-name');
            }
            var type = this._nameToType[name];
            BEM.DOM.update(this.elem('form'), BEMHTML.apply({
                block: 'b-ad-type',
                mods: {'lvl1-name': name},
                elem: 'form-content',
                typeId: type.id,
                limit: type.banners || type.min_banners,
                withLimitRange: (typeof type.min_banners !== 'undefined') && (typeof type.max_banners !== 'undefined')
            }));
            this.dropElemCache();
        }

    });
})();
