(function () {
    'use strict';

    BEM.DOM.decl('b-ad-type', {
        onSetMod: {
            js: function () {
                this.__base.apply(this, arguments);
                this._renderTypes();
                this._setSelectedMod();
            }
        },

        _initBlock: function () {
            this.__base.apply(this, arguments);
            // {number}
            this._limit = this.params.limit;
        },

        _renderTypes: function () {
            BEM.DOM.update(this.elem('types'), BEMHTML.apply({
                block: 'b-ad-type',
                elem: 'types-content',
                types: this.types
            }));
            this.dropElemCache('type');
        },

        _addListeners: function () {
            this.__base.apply(this, arguments);
            this.bindTo('type', 'click', this._onTypeClick.bind(this));
        },

        _onTypeClick: function (e) {
            e.stopPropagation();

            var $item = e.data.domElem;
            if (this.hasMod($item, 'selected', 'yes')) {
                return;
            }

            this.delMod(this.elem('type', 'selected', 'yes'), 'selected', 'yes');
            this._setSelectedMod($item, true);
        },

        /**
         * Выставляет мод у блока в зависимости от выбранного типа
         *
         * @param {jQuery} [$item] если не передан, то будет искать выделенный
         * @param {boolean} refreshCount
         **/
        _setSelectedMod: function ($item, refreshCount) {
            if (!$item || $item.length === 0) {
                $item = this._getItemToSelect();
            }
            if (!$item || $item.length === 0) {
                return;
            }

            var name = $item.attr('data-name').toLowerCase();

            if (refreshCount) {
                this._refreshCount(name);
            }

            this.setMod('lvl1-name', name);
            this.setMod($item, 'selected', 'yes');
        },

        _getItemToSelect: function () {
            var $item = this.elem('type', 'selected', 'yes');
            if (!$item || $item.length === 0) {
                // если еще не был выбран ни один элемент
                var id = this.params.type;
                if (id !== undefined && id !== 'undefined' && id.length > 0) {
                    // но был задан id
                    var name = this._getFirstName(id);
                    $item = this.elem('type').filter('[data-name="' + name + '"]');
                }
            }
            if (!$item || $item.length === 0) {
                // если никто не выделен, то может быть есть хоть какой-нибудь?
                $item = this.elem('type').eq(0);
            }
            if (!$item || $item.length === 0) {
                // нет, элементов нету совсем...
                return;
            }
            return $item;
        },

        _getFirstName: function (id) {
            var nameToType = this._nameToType,
                idToType = this._idToType,
                type = idToType[id];

            // добывает самого дальнего родителя
            function getParent(type) {
                var parentName = type.parentName;
                if (parentName !== undefined) {
                    return getParent(nameToType[parentName.toLowerCase()]);
                }
                return type;
            }

            return type && getParent(type).name;
        },

        _refreshCount: function (name) {
            var type = this._nameToType[name];
            this._limit = type.banners || 1;
        }
    });
})();
