(function () {
    'use strict';

    /**
     * Делает 2 хеша name:type и id:type
     **/
    function getHash(types) {
        function groupTypes(parentId, parentName, result, type) {
            if (parentId) {
                type.parentId = parentId;
            }

            if (parentName) {
                type.parentName = parentName;
            }

            // на всякие случай
            if (type.name !== undefined) {
                result.nameToType[type.name.toLowerCase()] = type;
            }
            // а вот id есть не у всех
            if (type.id !== undefined) {
                result.idToType[type.id] = type;
            }

            // делаем рекурсию, если есть вложенные типы
            if (type.types && type.types.length) {
                result.parentId = type.id;
                result.parentName = type.name;
                type.types.reduce(groupTypes.bind(null, type.id, type.name), result);
            }

            return result;
        }

        return types.reduce(groupTypes.bind(null, null, null), {nameToType: {}, idToType: {}});
    }

    BEM.DOM.decl('b-ad-type', {
        onSetMod: {
            js: function () {
                this._initBlock();
                this.afterCurrentEvent(this._addListeners, this);
            }
        },

        _initBlock: function () {
            // {array}
            this.types = this.params.types;

            var hash = getHash(this.params.types);
            // {string:object}
            this._idToType = hash.idToType;
            // {string:object}
            this._nameToType = hash.nameToType;
        },

        _addListeners: function () {

        }
    });
})();
