/*global alert*/
(function () {
    'use strict';

    var error = {
        block: {
            block: 'b-form-error',
            mix: [{block: 'b-ajax-form', elem: 'error-box'}]
        },
        elem: function (text) {
            return {
                block: 'b-form-error',
                elem: 'error',
                content: text
            };
        },
        input: function (text) {
            return {
                block: 'b-form-input',
                elem: 'message',
                elemMods: {type: 'error', visibility: 'visible'},
                content: text
            };
        }
    };

    BEM.DOM.decl('b-ajax-form', {
        onSetMod: {
            js: function () {
                // {b-form}
                this._bForm = null;
                // {bemBlocks}
                this._preDisabledList = [];

                this.__mask = this.elem('mask-spin').remove();
                if (this.params.autoLoad) {
                    var url = this.params.url;
                    this.load(url);
                }
            }
        },
        load: function (url){
            url = url || this.params.url;
            var that = this,
                d = $.Deferred();
            $.getJSON(url, {ajax: 1})
                .success(function (json){
                    that.build(json);
                    that.__loaded = true;
                    d.resolve();
                })
                .error(function () {d.fail();});
            return d;
        },
        build: function (bemJson) {
            if (bemJson.error) {
                this._triggerLoaded();
                alert(bemJson.error);
                return;
            }

            if (typeof bemJson.stage != 'undefined') {
                BEM.DOM.update(this.domElem, BEMHTML.apply({
                    block: 'b-wizard-form',
                    tab_names: bemJson.tab_names,
                    cur_tab: bemJson.stage,
                    content: bemJson.content,
                    url: this.params.url,
                    mods: {paranja: 'no'}
                }));
                this.findBlockInside('b-wizard-form')
                    .on('loaded', this._triggerLoaded, this)
                    .on('submit', function () {
                        this.trigger('submit');
                    }, this)
                    .on('action', function (e, b) {
                        this.trigger('action', b);
                    }, this);
            } else {
                this.dropElemCache();
                bemJson.unshift(error.block);
                BEM.DOM.update(this.domElem, BEMHTML.apply(bemJson));
                this._bForm = this.findBlockInside(this.domElem, 'b-form');
                this.form = $('form', this.domElem);
                this.form.submit(this, this._onSubmit.bind(this));
            }

            this._triggerLoaded();
        },
        isLoaded: function () {
            return this.__loaded;
        },
        invalidate: function () {
            BEM.DOM.destruct(false, this.domElem, true);
            this.__loaded = false;
        },
        clearErrors: function () {
            this.elem('error-box').html('');
            $('.b-form-input__message_type_error', this.domElem).remove();
        },
        addError: function (err) {
            this.elem('error-box').append(BEMHTML.apply(error.elem(err)));
        },
        showErrors: function () {
            if (this._bForm) {
                this._bForm.showErrors();
            }
        },
        hideErrors: function () {
            var bForm = this.findBlockInside(this.domElem, 'b-form');
            if (bForm) {
                bForm.hideErrors();
            }
        },
        enable: function () {
            this.doBlocksMethodInside('b-form-button', 'delMod', ['disabled']);
        },
        disable: function () {
            this.doBlocksMethodInside('b-form-button', 'setMod', ['disabled', 'yes']);
        },
        mask: function () {
            this.disable();
            if (this.__mask) {
                var submitButton = $('input[type=submit]', this.domElem).parents('.b-form-button');
                this.__mask.insertAfter(submitButton);
            }
        },
        unmask: function (){
            this.enable();
            if (this.__mask) {
                // т.к. кнопок может быть несколько, то и спинов
                // будет вставлено несколько, а в this.__mask будет
                // лежать только один - последний
                this.findElem('mask-spin').remove();
            }
        },
        _onSubmit: function () {
            if (!this._bForm.isValid()) {
                return;
            }

            this.trigger('submit');
            var data = this.form.serialize(),
                url  = this.params.url;
            this.clearErrors();
            if (data) {
                this.mask();
                $.post(url + (url.indexOf('?') > 0 ? '&' : '?') + 'ajax=1', data + '&ajax=1')
                    .success(this._onResponse.bind(this, data));
            }
            return false;
        },
        _errorHandler: function (d){
            this.clearErrors();
            if (d.error) {
                this.addError(d.error);
            }
            if (d.field_errors) {
                var inputs = this.findBlocksInside('b-form-input')
                    .reduce(function (obj, block) {
                        var name = block
                            .findElem('input')
                            .prop('name');

                        name &&
                            (obj[name] = block);

                        return obj;
                    }, {});

                var selects = this.findBlocksInside('b-form-select')
                    .reduce(function (obj, block) {
                        var name = block
                            .findElem('select')
                            .prop('name');

                        name &&
                            (obj[name] = block);

                        return obj;
                    }, {});

                var checkboxes = this.findBlocksInside('b-form-checkbox')
                    .reduce(function (obj, block) {
                        var name = block
                            .findElem('checkbox')
                            .prop('name');

                        name && !obj[name] &&
                            (obj[name] = block);

                        return obj;
                    }, {});

                var clids = this.findBlocksInside('b-form-clid-settings')
                    .reduce(function (obj, block) {
                        var name = block
                            .findBlockInside('checkbox', 'b-form-checkbox')
                            .findElem('checkbox')
                            .prop('name');

                        name &&
                            (obj[name] = block);

                        return obj;
                    }, {});

                var fields = $.extend({}, inputs, selects, clids, checkboxes);

                for (var n in d.field_errors) {
                    if (n in fields) {
                        if (typeof d.field_errors[n] === 'string') {
                            fields[n].showError(d.field_errors[n]);
                        } else {
                            /* Нестандартный случай для клидов,
                             * вместо строки с текстом ошибки
                             * может лежать объект с внутренними полями,
                             * которые содержат тексты ошибок */
                            var clidErrors = d.field_errors[n];
                            var clidControl = fields[n];
                            var innerElem;

                            for (var i in clidErrors) {
                                innerElem = clidControl
                                    .findElem(
                                        'radio-item',
                                        'type',
                                        i.replace('_', '-')
                                    );

                                innerElem &&
                                    this._showClidError(innerElem, clidControl, clidErrors[i]);
                            }
                        }
                    } else {
                        if (n === 'appearance') {
                            this._showAppearanceErrors(n, d.field_errors, fields);
                        } else if (n === 'rtb_multiformats') {
                            /* dirty fix */
                            this.findBlockInside('b-multiformats')
                                .showError(d.field_errors[n]);
                        } else {
                            /* Вероятно это мультиязычный инпут
                             * и тут будет небольшой хак для 2.13 */
                            var domElem = $('[name^="' + n + '"]').first();

                            if (domElem) {
                                try {
                                    var multilang = domElem.parent('.b-form-input');
                                    if (!multilang.length) {
                                        multilang = domElem.prevAll('.b-form-input');
                                    }
                                    multilang.bem('b-form-input')
                                    .showError(d.field_errors[n]);
                                } catch(e) {}
                            }
                        }
                    }
                }
            }
        },
        /**
         * @private
         * @param {string} n
         * @param {object} fieldErrors
         * @param {object} fields
         **/
        _showAppearanceErrors: function (n, fieldErrors, fields) {
            Object.keys(fieldErrors[n]).forEach(function (fieldName) {
                var name = n + '__' + fieldName;
                if (fields[name] !== 'undefined') {
                    fields[name].showError(fieldErrors[n][fieldName]);
                }
            });
        },
        _showClidError: function (ctx, block, msg) {
            block
                .findBlockInside(ctx, 'b-form-radio')
                .showError(msg);
        },
        _actionHandler: function (action, data) {
            this.trigger('action', {name: action, data: data});
        },
        _onResponse: function (sentData, data) {
            this.unmask();
            this.trigger('loaded');
            if (data.error || data.field_errors) {
                this._errorHandler(data);
            }
            if (data.action) {
                data.sentData = sentData;
                this._actionHandler(data.action, data.data);

                data.action === 'redirect' &&
                    (document.location = data.url);
            }
        },

        _triggerLoaded: function () {
            this.trigger('loaded');
        },
        doBlocksMethodInside: function (block, method, args) {
            this.findBlocksInside(block).forEach(function (block) {
                if (block[method]) {
                    block[method].apply(block, args);
                }
            });
        }
    });
})();
