(function (BEM, BEMHTML) {
    'use strict';

    BEM.DOM.decl('b-clipboard-dropdown', {
        onSetMod: {
            js: {
                inited: function () {
                    this._bPopup = this.findBlockInside('b-popupa');

                    this._rendered = false;
                    this._text = this.params.text;

                    if (this._bPopup) {
                        this._bPopup.on('show', this._onShow, this);
                    }
                }
            }
        },

        destruct: function () {
            if (this._bPopup) {
                this._bPopup.destruct();
            }
            this.__base.apply(this, arguments);
        },

        /**
         * Для отображения другого текста
         *
         * @param {string} text
         **/
        setText: function (text) {
            this._text = text;
            this._rendered = false;
        },

        /**
         * Показывает текст при открытии попапа
         **/
        _onShow: function () {
            if (this._rendered === false) {
                this.afterCurrentEvent(function () {
                    this._bPopup.setContent(BEMHTML.apply({
                        block: 'b-clipboard-dropdown',
                        elem: 'clipboard',
                        content: this._text
                    }));
                    this._rendered = true;
                }, this);
            }
        }
    });
})(BEM, BEMHTML);
