(function() {

BEM.DOM.decl('b-content-tabs', {
    onSetMod: {
        js: function() {
            this.tabs = this.elem('tab');

            this.bindTo('click', this.onTabClick, this);

            var cur = this.findElem('tab', 'selected', 'yes');
            this.setTab(cur);
        }
    },
    setTab: function(t) {
        if ( typeof t == 'object' ) {
            t = this.tabs.index(t);
        }

        if ( t == this.val ) {
            return;
        }

        var cur = this.findElem('tab', 'selected', 'yes'),
            newTab = this.tabs.eq(t);
        this.delMod(cur, 'selected', 'yes');
        this.setMod(newTab, 'selected', 'yes');
        this.val = t;
        this.trigger('change', t);
    },

    onTabClick: function(e) {
        var el = $(e.target).closest('.b-content-tabs__tab');

        this.setTab(el);
        e.preventDefault();
        return false;
    }
});

})();
