/*jslint bitwise: true, plusplus: true, nomen:true*/
/*globals window, document, jQuery, BEM, Ya*/

(function (w, d, n, s, t) {
    'use strict';
    w[n] = w[n] || [];
    t = d.documentElement.firstChild;
    s = d.createElement('script');
    s.type = 'text/javascript';
    s.src = '//an.yandex.ru/system/context.js';
    s.setAttribute('async', 'true');
    t.insertBefore(s, t.firstChild);
})(window, document, 'yandexContextAsyncCallbacks');

(function (window, BEM, $, undefined) {

    'use strict';

    var conf = {};

    BEM.DOM.decl('b-direct-preview', {
        onSetMod: {
            js: function () {
                var _this = this;

                (function check() {
                    if (!window.yandexContextAsyncCallbacks) {
                        window.setTimeout(check, 100);
                        return;
                    }

                    window.yandexContextAsyncCallbacks.push(function () {
                        _this._initDemo();
                    });
                })();
            }
        },

        _initDemo: function () {
            window.Ya.Context.Loader.load = function () {
                this._startLoading = false;
                this._lastReloadTime = 0;
                this._data = getAds(conf.adsNum || 2);
                this.validateData();
                this.fireEvent('loaded', this);
            };

            Ya.Context.Adv.prototype.removeOverflow = function () {};

            this.update({
                type:            this.params.type,
                site_bg_color:   this.params.siteBgColor,
                bg_color:        this.params.bgColor,
                border_color:    this.params.borderColor,
                header_bg_color: this.params.headerBgColor,
                title_color:     this.params.titleColor,
                url_color:       this.params.urlColor,
                all_color:       this.params.allColor,
                text_color:      this.params.textColor,
                hover_color:     this.params.hoverColor,
                favicon:         this.params.favicon,
                border_radius:   this.params.borderRadius
            });

            this.trigger('init');
        },

        update: function (options) {
            var id = 'demo-id-' + getUniqueString(),
                settings,
                container = this.domElem,
                block;

            options = options || this.conf;

            $.extend(conf, defaults, options);

            settings = blockSettings[conf.type] || blockSettings['default'];
            conf.adsNum = settings.ads;

            this.conf = clone(conf);

            container.html('<div class="" id="' + id + '"></div>')
                .css('background', '#' + conf.site_bg_color);

            if (typeof Ya !== 'undefined' && Ya && Ya.Direct) {
                Ya.Direct.insertInto(53618, id, conf);
                block = Ya.Context.AdvManager.getBlockByElId(id);
                block.removeVisibilityCheck();
            }
        }
    });

    var blockSettings = {
        'default': {ads: 2},
        '728x90':  {ads: 2},
        '240x400': {ads: 3},
        '160x600': {ads: 4},
        '300x250': {ads: 2}
    };

    var ads = [
        {url: 'http://direct.yandex.ru',  title: 'Сделаем из мухи слона!',
            body: 'Стремительный рост вашему бизнесу обеспечит контекстная реклама в Директе'},
        {url: 'http://metrika.yandex.ru', title: 'А слона-то я и не приметил!',
            body: 'Со счетчиком Яндекс.Метрики вы будете знать все о посетителях вашего сайта!'},
        {url: 'http://partner.yandex.ru', title: 'Слоновому сайту слоновый доход',
            body: 'Делимся с лучшими сайтами доходом от размещения контекстной рекламы'},
        {url: 'http://www.yandex.ru',     title: 'По улицам Слона водили, И.А.Крылов',
            body: 'Любимые стихи о найдутся быстрее с помощью Стихолюба от Яндекса!'},
        {url: 'http://maps.yandex.ru',    title: 'Село Красный Слон на карте',
            body: 'Россия, Ярославская область, Любимский район. Весь мир на Яндекс.Картах.'},
        {url: 'http://pogoda.yandex.ru',  title: 'Если слоны летают, это к дождю?',
            body: 'Не верьте в народные приметы. Лучше смотрите погоду на Яндексе.'},
        {url: 'http://afisha.yandex.ru',  title: 'Слон, получивший степень MBA!',
            body: 'Играет в шахматы и занимается йогой! В московском цирке на Цветном бульваре'},
        {url: 'http://direct.yandex.ru',  title: 'Сделаем из мухи слона!',
            body: 'Стремительный рост вашему бизнесу обеспечит контекстная реклама в Директе'},
        {url: 'http://money.yandex.ru',   title: 'Купи слона - доставка бесплатно!',
            body: 'Еще больше товаров и услуг теперь доступны за Яндекс.Деньги, без переплат!'},
        {url: 'http://moikrug.ru',        title: 'Дрессировщик индийских слонов',
        body: 'Кажется, это единственная вакансия, которую Мой Круг не поможет закрыть'}
    ];

    var defaults = {
        onRtb: false,
        partnerId: '777',
        ad_format: 'direct',
        border_type: 'block',
        direct_header_position: 'bottom'
    };

    function makeAd(data) {
        return {
            url: data.url,
            title: data.title,
            body: data.body,
            domain: data.url.replace(/^https?\:\/\/([a-z\.]+)\/?.*$/, '$1'),
            region: '',
            vcardurl: data.url,
            callurl: data.url,
            warning: '',
            sitelinks: [
                {title: '', url: ''},
                {title: '', url: ''},
                {title: '', url: ''}
            ],
            linkTail: '',
            debug: ''
        };
    }

    function getAds(num) {
        num = num || 2;

        return {
            common: {linkHead: '', domains: []},
            direct: {
                ads: ads.slice(0, num).map(makeAd),
                directTitle: {title: 'Яндекс.Директ', url: 'http://advertising.yandex.ru/'},
                linkAll: {title: 'Все объявления', url: '#'}
            }
        };
    }

    function getUniqueString() {
        return (new Date()).getTime().toString(36);
    }

    function clone(obj) {
        return JSON.parse(JSON.stringify(obj));
    }

})(window, BEM, jQuery);
