(function () {
    'use strict';

    function dspData(data) {
        data = data || {};

        return {
            id: data.id,
            url: data.url,
            testUrl: data.test_url,
            tag: data.tag
        };
    }

    BEM.DOM.decl('b-dsp-selector', {
        onSetMod: {
            js: function () {
                this.dspId = this.params.dspId;
                this.dspData = this.params.dspData;
                this.select = this.findBlockOn('select', 'b-form-select');
                if (this.select) {
                    this.select.on('change', this.updateDsp, this);
                }
                this.afterCurrentEvent(this.updateDsp.bind(this));
            }
        },

        updateDsp: function () {
            var dspId;

            if (this.select) {
                dspId = this.select.val();
            } else {
                dspId = this.dspId;
            }

            var dsp = dspData(this.dspData[dspId]);

            this.elem('label-dsp-id').text(
                BEM.I18N('b-dsp-selector', 'DSP ID:') + (dsp.id ? ' ' + dsp.id : '')
            );
            this.elem('label-dsp-url').text(
                BEM.I18N('b-dsp-selector', 'URL for RTB host:') + (dsp.url ? ' ' + dsp.url : '')
            );
            this.elem('label-dsp-test-url').text(
                dsp.testUrl ?
                    BEM.I18N('b-dsp-selector', 'Test URL for RTB host:')  + ' ' + dsp.testUrl :
                    BEM.I18N('b-dsp-selector', 'Test URL for RTB host: no')
            );

            this.trigger('change', dsp);
        }
    }, {});

})();
