(function (BEM) {
    'use strict';

    var promises = BEM.blocks['i-promises'],
        ajax = promises.ajax;

    BEM.DOM.decl('b-dsp-statistics-responses', {
        onSetMod: {
            js: function () {
                this.form = this.elem('form');
                this.dspChanged = true;
                this.dspSelector = this.findBlockInside('b-dsp-selector');
                this.olap = this.findBlockInside('olap', 'b-olap');
                this.olapControls = this.findBlockInside('olap-controls', 'b-olap-controls');
                this.submitButton = this.findBlockInside('submit-button', 'b-form-button');
                this.loadingPopup = this.findBlockOn('loading-popup', 'b-progress-popup');
                this.daterange = this.findBlockInside('daterange', 'b-form-daterange');

                this.clearResults();

                this.form.submit(this.onSubmit.bind(this));
                this.daterange.on('change', this.onPeriodChanged, this);
                this.dspSelector.on('change', this.onDspSelectorChanged, this);
            },
            loading: function (modName, modVal) {
                if (modVal === 'yes') {
                    this.submitButton.setMod('disabled', 'yes');
                    this.loadingPopup.setMod('progress', 'on');
                } else {
                    this.loadingPopup.delMod('progress');
                    this.submitButton.delMod('disabled');
                }
            }
        },

        clearResults: function () {
            this.elem('results-container').hide();
            this.elem('errors-container').hide();
        },

        onDspSelectorChanged: function (e, dspData) {
            this.dspChanged = true;
            this.elem('dsp-id').val(dspData.id);
        },

        onPeriodChanged: function () {
            this.delMod('wrong-period');
        },

        onSubmit: function (e) {
            e.preventDefault();
            this.buildStatistic();
        },

        buildStatistic: function () {
            var equals = function (a, b) {
                return Object.keys(a).every(function (key) {
                    return a[key] === b[key];
                });
            };

            if (this.daterange.valIsSelected()) {
                var data = this.form.serialize();
                var olapControlsValues = this.olapControls.val();
                this.olap.setFilters(olapControlsValues.filters);
                this.olap.setGroupBy(olapControlsValues.groupBy);

                var period = this.daterange.val();
                if (!this.dspChanged && this.period && equals(period, this.period) && this.olap.hasData()) {
                    this.olap.buildResults();
                } else {
                    this.setMod('loading', 'yes');
                    this.clearResults();
                    ajax.postJSON(this.params.action, data)
                        .then(this.updateResponse.bind(this))
                        .then(this.updateErrors.bind(this));
                }

                this.period = period;
            } else {
                this.setMod('wrong-period', 'yes');
            }
        },

        updateErrors: function (response) {
            var error = response.error;

            if (error) {
                this.elem('errors').text(error);
                this.elem('errors-container').show();

                return null;
            } else {
                return response;
            }
        },

        updateResponse: function (response) {
            this.delMod('loading');
            this.dspChanged = false;
            if (response && Array.isArray(response.data)) {
                this.elem('results-container').show();
                this.olap.setData(response.data);
                this.olap.buildResults();
                return response;
            } else {
                this.olap.clearData();
                response = response || {};
                response.error = response.error || 'Invalid response';
                return response;
            }
        }
    });

})(BEM);
