(function() {

var FeedMgr = {
    _feedMap: {},
    init: function() {
        this.pull();
    },
    addFeed: function(feed) {
        var url = feed.params.url;
        if ( !url ) {
            throw Error('no url in b-feed params');
        }
        if ( !this._feedMap[url] ) {
            this._feedMap[url] = [feed];
        }
        else {
            this._feedMap[url].push(feed);
        }
    },
    pull: function(feed) {
        if ( feed && this._feedMap[feed.params.url] ) {
            var url = feed.params.url;
            this._puller(this._feedMap[url], url);
        }
        else {
            _.each(this._feedMap, this._puller, this);
        }
    },
    _puller: function(feeds, url) {
        $.get(url, { ajax: 1 })
            .success(function(resp) {
                _.each(feeds, function(feed) {
                    var field = feed.params.field;
                    if ( field && field in resp ) {
                        feed.setContent(resp[field]);
                    }
                    else {
                        feed.showError();
                    }
                });
            })
            .error(function() {
                _.each(feeds, function(feed){
                    feed.showError();
                });
            });
    }
}

$(function() {
    FeedMgr.init();
});

BEM.DOM.decl('b-feed', {
    onSetMod: {
        js: function() {
            FeedMgr.addFeed(this);
            this.elem('loader').show();
        }
    },
    showError: function() {
        var error = this.defaultError || this.params.error_content;
        this.domElem.html(typeof error == 'string' ? error : BEMHTML.apply(error));
        this.setMod('error', 'yes');
    },
    setContent: function(content) {
        this.domElem.html(typeof content == 'string' ? content : BEMHTML.apply(content));
        this.setMod('loaded', 'yes');
    },
    defaultError: 'No data'
});

BEM.DOM.decl({ block: 'b-feed', modName: 'type', modVal: 'bool'}, {
    setContent: function(rawContent) {
        var trueVal = this.params.trueVal || 'Yes',
            falseVal = this.params.falseVal || 'No',
            content = this.toBool(rawContent) ? trueVal : falseVal;
        this.domElem.html(typeof content == 'string' ? content : BEMHTML.apply(content));
        this.setMod('loaded', 'yes');
    },
    toBool: function(val){
        if ( val == '0' ) {
            return false;
        }
        return !!val;
    }
});

})();
