/**
*
* @author Ilya Rezvov <irezvov@yandex-team.ru>
* @date 2012
* @description Module describes field editor for boolean fields.
*
*/

BEM.DOM.decl({ block: 'b-field-editor', modName: 'type', modVal: 'boolean'}, {

    /**
    * @public
    * Render block
    *
    */
    build: function(f) {
        this.__base(f);

        this.value = this.findBlockOn('value', 'b-form-radio');
    },

    /**
    * @public
    * Get or set value of field editor
    *
    * @param val Value, if exist, then set value for val
    * @return Value
    * @trigger change
    */
    val: function(v) {
        // set value
        if ( typeof v != 'undefined' ) {
            var val = this.stringToValue(v);
            this.value.val(val);
            this.trigger('change', this);
            return val;
        }
        // get value
        else {
            return this.valueToString(this.value.val());
        }
    },

    /**
    * @protect
    * Convert value from internal representation to external
    *
    * @param {string} value
    */
    valueToString: function(v) {
        var vals = {
                'on': 1,
                'off': 0,
                'undef': ''
            };

        return vals[v];
    },

    /**
    * @protect
    * Convert value from external representation to internal
    *
    * @param {string} value
    */
    stringToValue: function(v) {
        if (v === undefined || v === null || v === '') {
            return 'undef';
        }
        else {
            return ({ '0': 'off', '1': 'on' })[v];
        }
    },

    /**
    * @protect
    * Polymorfic function for build block content
    * it overrides bottom block implementation
    *
    */
    builder: function(f) {
        return {
            val: {
                block: 'b-form-radio',
                mix: [ {block: 'b-field-editor', elem: 'value' } ],
                mods: { size: 'l', theme: 'grey' },
                content: [
                    {
                        elem: 'button',
                        inputAttrs: { value: 'on' },
                        content: 'Да'
                    },
                    {
                        elem: 'button',
                        inputAttrs: { value: 'off' },
                        content: 'Нет'
                    },
                    {
                        elem: 'button',
                        inputAttrs: { value: 'undef' },
                        elemMods: { checked: 'yes' },
                        content: 'Всё равно'
                    }
                ]
            }
        }
    },

    /**
    * @public
    * Return current operation of condition
    * it is constant for this type block
    *
    */
    op: function() {
        return '=';
    }
});
