// @description Module describes block for editing values of entity fields of contractnumber type.
(function () {
    'use strict';
    BEM.DOM.decl({block: 'b-field-editor', modName: 'type', modVal: 'login'}, {
        onSetMod: {
            js: function () {
                this.__base();

                this.operation.on('change', this._onOperationChange, this);
                this.afterCurrentEvent(this._onOperationChange, this);
                this._addMultiListener();
            }
        },
        val: function (v) {
            this.afterCurrentEvent(this._refreshValueMulti, this);

            function isNotEmpty(val) {
                return val.length > 0;
            }

            if (this.op() === 'IN' || this.op() === 'NOT IN') {
                if (v === undefined) {
                    var val = $.trim(this.__base());
                    return !val ? [] : val.split(/[\s,;\t]+/).filter(isNotEmpty);
                } else {
                    return Array.isArray(v) ? this.__base(v.join(', ')) : this.__base(v);
                }
            } else {
                return this.__base(v);
            }
        },
        makeInput: function (elem) {
            var url = '/settings/login_sgst',
                search = this.params.search,
                size = this.getMod('size') || 's';
            if (search) {
                url += '?' + search;
            }
            var multisuggest = {
                    block: 'b-form-input',
                    mods: {theme: 'grey', size: size, multisuggest: 'yes'},
                    mix: [
                        {block: 'b-field-editor', elem: 'login-multi'}
                    ],
                    js: {dataprovider: {url: url}},
                    content: {
                        elem: 'input',
                        attrs: {name: 'login', value: '', id: Math.random().toString()}
                    }
                }, input = {
                    block: 'b-form-input',
                    mods: {theme: 'grey', size: size},
                    content: {
                        elem: 'input',
                        attrs: {name: 'login', value: '', id: Math.random().toString()}
                    }
                };

            if (elem) {
                input.mix = [{block: 'b-field-editor', elem: elem, mods: {type: 'input'}}];
            }

            return [input, multisuggest];
        },
        build: function () {
            this.__base.apply(this, arguments);
            this.valueMulti = this.findBlockOn('login-multi', 'b-form-input');
            this.operation.trigger('change');
        },
        _onOperationChange: function () {
            if (this.op() === 'IN' || this.op() === 'NOT IN') {
                this._refreshValueMulti();
                this._showMultisuggest();
            } else {
                this._showText();
            }
        },
        _showMultisuggest: function () {
            var text = this.value,
                multi = this.valueMulti,
                hidden = this.buildSelector('hidden').slice(1);

            if (text.domElem.hasClass(hidden)) {
                return;
            }

            text.domElem.addClass(hidden);
            multi.domElem.removeClass(hidden);
        },
        _showText: function () {
            var multi = this.valueMulti,
                text = this.value,
                hidden = this.buildSelector('hidden').slice(1);

            if (multi.domElem.hasClass(hidden)) {
                return;
            }

            multi.domElem.addClass(hidden);
            text.domElem.removeClass(hidden);
        },

        _refreshValueMulti: function () {
            var val = this.value.val();

            if (val.length) {
                this.valueMulti.val(val.split(/[\s,;\t]+/).join(','));
            }
        },

        _refreshValue: function () {
            var val = this.valueMulti.val();

            if (val.length) {
                this.value.val(val.split(',').join(' '));
            } else {
                this.value.val(val);
            }
        },

        _addMultiListener: function () {
            this.valueMulti.on('change', this._refreshValue, this);
        }
    });
})();
