/**
*
* @author Ilya Rezvov <irezvov@yandex-team.ru>
* @date 2012
* @description Module describes field editor for fields with predefined variants of input.
*
*/

(function (BEM) {
    'use strict';

    BEM.DOM.decl({block: 'b-field-editor', modName: 'type', modVal: 'multistate'}, {

        /**
        * @public
        * Render block
        *
        */
        build: function(f) {
            this.__base(f);

            this.value = this.findBlockOn('value', 'b-form-select');
        },

        /**
        * @protect
        * Polymorfic function for build block content
        * it overrides bottom block implementation
        *
        */
        builder: function(f) {
            var vals = $.extend(true, {'': BEM.I18N('b-field-editor', 'Any')}, f.values),
                ops = this.makeSelectOptions(vals),
                value = this.makeSelect( ops, 'value' );
            return {val: value};
        },

        /**
        * @public
        * Return current operation of condition
        * it is constant for this type block
        *
        */
        op: function() {
            return '=';
        }
    });

})(BEM);
