(function (BEM, undefined){
    'use strict';

    /**
     * @param {bem-block} trigger
     * @return {boolean}
     **/
    function isChecked(trigger) {
        var checked = false;

        if (typeof trigger !== 'undefined' && trigger !== null) {
            checked = trigger.getMod('checked') === 'yes';
        }

        return checked;
    }

    BEM.DOM.decl({block: 'b-fieldgroup', modName: 'label', modVal: 'checkbox'}, {
        onSetMod: {
            disabled: {
                yes: function () {
                    this._getTrigger().setMod('disabled', 'yes');
                    this._getField().setMod('disabled', 'yes');
                },
                '': function () {
                    this._getTrigger().delMod('disabled');
                    if (this._isChecked() || !this.hasMod('nullable', 'yes')) {
                        this._getField().delMod('disabled');
                    }
                }
            }
        },

        /**
         * @protected
         **/
        _onCheck: function () {
            this.__base.apply(this);
            this._getTrigger().setMod('checked', 'yes');
        },

        /**
         * @protected
         **/
        _onUncheck: function () {
            this.__base.apply(this);
            this._getTrigger().delMod('checked');
        },

        /**
         * @protected
         **/
        _isChecked: function () {
            return isChecked(this._getTrigger());
        },

        /**
         * @protected
         * @return {b-form-checkbox}
         **/
        _getTrigger: function () {
            this._trigger = this._trigger || this.findBlockOn('trigger', 'b-form-checkbox');
            return this._trigger;
        }
    });
})(BEM);
