(function (BEM, undefined){
    'use strict';

    /**
     * @param {jQuery} trigger
     **/
    function isChecked(trigger) {
        var checked = false;

        if (trigger && trigger.length) {
            checked = trigger.prop('checked');
        }

        return checked;
    }

    BEM.DOM.decl({block: 'b-fieldgroup', modName: 'label', modVal: 'radio'}, {
        onSetMod: {
            disabled: {
                yes: function () {
                    this.elem('trigger').attr('disabled', 'disabled');
                    this._getField().setMod('disabled', 'yes');
                },
                '': function () {
                    this.elem('trigger').removeAttr('disabled');
                    if (this._isChecked() || !this.hasMod('nullable', 'yes')) {
                        this._getField().delMod('disabled');
                    }
                }
            }
        },

        /**
         * @protected
         **/
        _onCheck: function () {
            this.__base.apply(this);
            this.elem('trigger').prop('checked', true).trigger('change');
        },

        /**
         * @protected
         **/
        _onUncheck: function () {
            this.__base.apply(this);
            this.elem('trigger').prop('checked', false).trigger('change');
        },

        /**
         * @protected
         * @return {string}
         **/
        _getTriggerValue: function () {
            return this.elem('trigger').attr('value');
        },

        /**
         * @protected
         * @return {boolean}
         **/
        _isChecked: function () {
            return isChecked(this.elem('trigger'));
        },

        /**
         * @protected
         * @return {jQuery} jQuery массив инпутов; нужен, чтобы слушать событие change
         **/
        _getTrigger: function () {
            if (!this._trigger) {
                this._trigger = $('input[name="' + this.elem('trigger').attr('name') + '"]');
            }
            return this._trigger;
        }
    });

})(BEM);
