(function (BEM, undefined){
    'use strict';

    BEM.DOM.decl({block: 'b-fieldgroup', modName: 'nullable', modVal: 'yes'}, {
        onSetMod: {
            js: function () {
                this.__base.apply(this, arguments);
                if (!this._isChecked()) {
                    this._getField().setMod('disabled', 'yes');
                }
            },
            checked: {
                yes: function () {
                    this._onCheck();
                },
                '': function () {
                    this._onUncheck();
                }
            }
        },

        /**
         * @protected
         **/
        _onCheck: function () {
            this.__base.apply(this);
            this._getField().delMod('disabled');
        },

        /**
         * @protected
         **/
        _onUncheck: function () {
            this.__base.apply(this);
            var field = this._getField();
            field.setMod('disabled', 'yes');
            field.hideError();
        }
    });
})(BEM);
